/*	zap technologies - copyright 1999
/*	http://www.zaptech.com
/*
/*  This file contains the model building routines.
/*
/*  1999-10-31 - added support for Group node
/*  1999-04-04 - split off parse.c
/*  1999-03-21 - overhauled for Universal Headers 3.X
/*  1999-02-05 - overhauled for VN_NodeLink use
/*  1997-12-19 - Open3dView() case TVFSOP_FLOAT
/*      now actually parses float value and assigns
/*      to current node field data storage
/*  1997-07-06 - InitMeshModel() now online
/*  1997-07-02 - created
/*
/*  Note:
/*  - most routines return 0 if an error occurs
/*  - many routines will set global string pointer errorMsg
/*    if they encounter an error
*/

/*  headers  */
#include <Controls.h>
#include <Errors.h>
#include <QD3D.h>
#include <QD3DGeometry.h>
#include <QD3DGroup.h>
#include <QD3DMath.h>
#include <QD3DTransform.h>
#include <QD3DCamera.h>
#include <QD3DDrawContext.h>
#include <QD3DView.h>
#include <QD3DShader.h>
#include <QD3DLight.h>
#include <QD3DRenderer.h>

#include "twirl.h"
#include "parse.h"
#define H_MODEL_PROTOS
#include "models.h"
#undef H_MODEL_PROTOS
#include "vrml.h"
#include "myio.h"


/*  local function prototypes  */
struct OpaqueTQ3Object *InitFaceModel(struct VN_IndexedFaceSet *node);  /*
TQ3Status drawOrigin(TQ3ViewObject view);
short new2(struct docWindowView *doc);
void traverse(struct VN_NodeLink *nodelink, TQ3ViewObject view);
void traverseOld(struct VN_Nod *node, TQ3ViewObject view);
int matchNode(struct docWindowView *doc);
int matchField(struct fileBufRec0 *bufRec);
short add(struct fileBufRec0 *bufRec, char type);
char *AllocValueArrayPtr(Handle Hdl, long size);
Handle AllocValueArrayHandle();


/*  external global variables  */
extern wprintDocument statDoc;
extern TQ3Status statusQD3D;
extern char *errorMsg;
extern short flags;
extern struct VN_FIELDDATATYPEINFO fieldTypeInfo[];
extern struct VN_STRUCTINFO nodeInfo[];


/*  Init4boxModel  */
/*  returns a *model if successful  */
struct OpaqueTQ3Object *Init4boxModel() {
	TQ3GeometryObject myBox = { 0 };
	struct OpaqueTQ3Object *model = 0;  /*  parent type of TQ3GroupObject  */
	TQ3BoxData myBoxData;
	TQ3ColorRGB faceColor;
	TQ3TransformObject transform;
	TQ3Vector3D translation = { 0 };
	TQ3SetObject faces[6];
	short face, box, x, y, z, lx, ly, lz;

	if (model = Q3DisplayGroup_New()) {
		/*  setup box object attribute data  */
		myBoxData.faceAttributeSet = faces;
		myBoxData.boxAttributeSet = nil;
		/*  add attribute set to each face  */
		for (face = 0; face < 6; face++) {
			myBoxData.faceAttributeSet[face] = Q3AttributeSet_New();
			faceColor.r = (32768 + Random()) / 65535.0;
			faceColor.g = (32768 + Random()) / 65535.0;
			faceColor.b = (32768 + Random()) / 65535.0;
			Q3AttributeSet_Add(myBoxData.faceAttributeSet[face],
				kQ3AttributeTypeDiffuseColor, &faceColor);
			}
		Q3Point3D_Set(&myBoxData.origin, -0.5, -0.5, -0.5);
		Q3Vector3D_Set(&myBoxData.orientation, 0, 1, 0);
		Q3Vector3D_Set(&myBoxData.majorAxis, 0, 0, 1);	
		Q3Vector3D_Set(&myBoxData.minorAxis, 1, 0, 0);	
		myBox = Q3Box_New(&myBoxData);
		/*  Add translated box objects to model group  */
		if (myBox) {
			face = Random() & 0xF;
			if (flags & F_LOG)
				if (statDoc.winPtrx) wprintf(&statDoc, "\ngenerating %d boxes", face);
			x = 0;  y = 0;  z = 0;
			for (box = 0; box < face; box++) {
				lx = x;  x = (Random() >> 14) + (Random() & 1);
				ly = y;  y = (Random() >> 14) + (Random() & 1);
				lz = z;  z = (Random() >> 14) + (Random() & 1);
				translation.x = (x - lx);
				translation.y = (y - ly);
				translation.z = (z - lz);
//				statf("\n xlate%3d%3d%3d ", dx, dy, dz);
//				statf("\nbox%2d:%3d%3d%3d", box, x, y, z);
				transform = Q3TranslateTransform_New(&translation);
				Q3Group_AddObject(model, transform);
				Q3Object_Dispose(transform);
				Q3Group_AddObject(model, myBox);
				}
			Q3Object_Dispose(myBox);
			}
		/*  dispose box attribute face attribute set  */
		for (face = 0; face < 6; face++) {
			if (myBoxData.faceAttributeSet[face] != NULL)
				Q3Object_Dispose(myBoxData.faceAttributeSet[face]);
			}
		/*  If an error occured above, may need to dispose of group object pointer  */
		//  Q3Object_Dispose(model);  model = 0;
		}
	return (model);
	}  /*  MyNewModel()  */


/*	static */TQ3Param2D UV[3] = { 0 };

/*  InitMeshModel  */
/*  returns a *model if successful  */
struct OpaqueTQ3Object *InitMeshModel() {
	TQ3Vertex3D vertex[3] = { 0 };
	TQ3MeshVertex meshVertices[3] = { 0 };
	TQ3GeometryObject mesh = { 0 };
	TQ3AttributeSet verticeAttr = { 0 };
	TQ3AttributeSet faceAttr = { 0 };
	TQ3MeshFace meshFace = { 0 };
	struct OpaqueTQ3Object *model = 0;    /*  TQ3GroupObject  */
	TQ3ColorRGB meshColor;
	short i, face, nfaces;

	/*  allocate group object  */
	if (!(model = Q3DisplayGroup_New()))
		goto exit;
	/*  allocate mesh  */
	if (!(mesh = Q3Mesh_New())) {
exitmo:	Q3Object_Dispose(model);  model = 0;
		goto exit;
		}
	/*  block update access to mesh  */
	if ((statusQD3D = Q3Mesh_DelayUpdates(mesh)) == kQ3Failure)
		goto exitmomesh;
	/*  add random number of faces to mesh  */
	nfaces = ((Random() + 32768) >> 13) + ((Random() + 32768) >> 13);
	for (face = 0; face < nfaces; face++) {
		for (i = 0; i < 3; i++) {
			vertex[i].point.x = ((Random() >> 14) + (Random() & 1));
			vertex[i].point.y = ((Random() >> 14) + (Random() & 1));
			vertex[i].point.z = ((Random() >> 14) + (Random() & 1));
			meshVertices[i] = Q3Mesh_VertexNew(mesh, &vertex[i]);
			if (!meshVertices[i]) {
exitmomesh:		Q3Object_Dispose(model);  model = 0;
				goto exitmesh;
				}
			verticeAttr = Q3AttributeSet_New();  //  error?
			Q3AttributeSet_Add(verticeAttr, kQ3AttributeTypeSurfaceUV, &UV[i]);  //  error?
			Q3Mesh_SetVertexAttributeSet(mesh, meshVertices[i], verticeAttr);  //  error?
			Q3Object_Dispose(verticeAttr);  //  error?
			}
		faceAttr = Q3AttributeSet_New();  //  error?
		meshColor.r = (Random() + 32768) / 65535.0;
		meshColor.g = (Random() + 32768) / 65535.0;
		meshColor.b = (Random() + 32768) / 65535.0;
		Q3AttributeSet_Add(faceAttr, kQ3AttributeTypeDiffuseColor, &meshColor);  //  error?
		meshFace = Q3Mesh_FaceNew(mesh, 3, meshVertices, faceAttr);  //  error?
//		if (flags & F_LOG)
//			if (statDoc.winPtrx) wprintf(&statDoc, "\n3D Q3Mesh_FaceNew() %d success", face);
		Q3Object_Dispose(faceAttr);
		}
//		meshFace = Q3Mesh_FaceNew(mesh, 3, &meshVertices[9], faceAttr);  //  error?
//		Q3Mesh_FaceToContour(mesh, meshFace,
//			Q3Mesh_FaceNew(mesh, 3, &meshVertices[6], 0));  //  error?
	Q3Mesh_ResumeUpdates(mesh);  //  error?
	Q3Group_AddObject(model, mesh);  //  error?
exitmesh:
	Q3Object_Dispose(mesh);
exit:
	return (model);
	}  /*  InitMeshModel()  */


/*  InitBoxModel  */
/*  returns a *model if successful  */
struct OpaqueTQ3Object *InitBoxModel(struct VN_Nod *node) {
	static TQ3Point3D point[16] = {
	   0.5, 0.5, 0.5,  0.5, 0.5,-0.5,  /*  0, 1  */
	   0.5,-0.5, 0.5,  0.5,-0.5,-0.5,  /*  2, 3  */
	  -0.5, 0.5, 0.5, -0.5, 0.5,-0.5,  /*  4, 5  */
	  -0.5,-0.5, 0.5, -0.5,-0.5,-0.5   /*  6, 7  */
	  };
	static char poo[] = {
	   0, 1, 5,  5, 4, 0,  /*  top  */
	   2, 6, 7,  7, 3, 2,  /*  bottom  */
	   4, 5, 7,  7, 6, 4,  /*  left  */
	   0, 2, 3,  3, 1, 0,  /*  right  */
	   0, 4, 6,  6, 2, 0,  /*  front  */
	   1, 3, 7,  7, 5, 1   /*  back  */
	  };
	static TQ3Param2D UV[3] = { 0 };
	TQ3Vertex3D vertex[3] = { 0 };
	TQ3MeshVertex meshVertices[3] = { 0 };
	TQ3GeometryObject mesh = { 0 };
	TQ3AttributeSet verticeAttr = { 0 };
	TQ3AttributeSet faceAttr = { 0 };
	TQ3MeshFace meshFace = { 0 };
	struct OpaqueTQ3Object *model = 0;    /*  TQ3GroupObject  */
	TQ3ColorRGB meshColor;
	float x, y, z;
	short i, j, face, nfaces;

	/*  check that parameters define a positive volume  */
	x = ((struct VN_Box *) node)->size[0];
	if (x <= 0.0)
		goto exit;
	y = ((struct VN_Box *) node)->size[1];
	if (y <= 0.0)
		goto exit;
	z = ((struct VN_Box *) node)->size[2];
	if (z <= 0.0)
		goto exit;
	/*  allocate group object  */
	if (!(model = Q3DisplayGroup_New()))
		goto exit;
	/*  allocate mesh  */
	if (!(mesh = Q3Mesh_New())) {
exitmo:	Q3Object_Dispose(model);
		model = 0;
		goto exit;
		}
	/*  block update access to mesh  */
	if ((statusQD3D = Q3Mesh_DelayUpdates(mesh)) == kQ3Failure)
		goto exitmomesh;
	meshColor.r = (Random() + 32768) / 65535.0;
	meshColor.g = (Random() + 32768) / 65535.0;
	meshColor.b = (Random() + 32768) / 65535.0;
	/*  stitch up faces  */
	nfaces = 12;
	for (face = 0, j = 0; face < nfaces; face++, j += 3) {
		for (i = 0; i < 3; i++) {
			vertex[i].point.x = point[poo[i + j]].x * x;
			vertex[i].point.y = point[poo[i + j]].y * y;
			vertex[i].point.z = point[poo[i + j]].z * z;
			meshVertices[i] = Q3Mesh_VertexNew(mesh, &vertex[i]);
			if (!meshVertices[i]) {
exitmomesh:		Q3Object_Dispose(model);  //  error?
				model = 0;
				goto exitmesh;
				}
			verticeAttr = Q3AttributeSet_New();  //  error?
			Q3AttributeSet_Add(verticeAttr, kQ3AttributeTypeSurfaceUV, &UV[i]);  //  error?
			Q3Mesh_SetVertexAttributeSet(mesh, meshVertices[i], verticeAttr);  //  error?
			Q3Object_Dispose(verticeAttr);  //  error?
			}
		faceAttr = Q3AttributeSet_New();  //  error?
//		meshColor.r = (Random() + 32768) / 65535.0;
//		meshColor.g = (Random() + 32768) / 65535.0;
//		meshColor.b = (Random() + 32768) / 65535.0;
		Q3AttributeSet_Add(faceAttr, kQ3AttributeTypeDiffuseColor, &meshColor);  //  error?
		meshFace = Q3Mesh_FaceNew(mesh, 3, meshVertices, faceAttr);  //  error?
		Q3Object_Dispose(faceAttr);
		}
	Q3Mesh_ResumeUpdates(mesh);  //  error?
	Q3Group_AddObject(model, mesh);  //  error?
exitmesh:
	Q3Object_Dispose(mesh);
exit:
	return (model);
	}


/*  InitCylinderModel  */
/*  returns a *model if successful  */
struct OpaqueTQ3Object *InitCylinderModel(struct VN_Nod *node) {
	static TQ3Point3D point[16] = {
	   0.0,-0.5,-1.0,  0.7,-0.5,-0.7,  1.0,-0.5, 0.0,  0.7,-0.5, 0.7,  /*   0,  1,  2,  3  */
	   0.0,-0.5, 1.0, -0.7,-0.5, 0.7, -1.0,-0.5, 0.0, -0.7,-0.5,-0.7,  /*   4,  5,  6,  7  */
	   0.5, 0.5,-0.8,  0.8, 0.5,-0.5,  0.8, 0.5, 0.5,  0.5, 0.5, 0.8,  /*   8,  9, 10, 11  */
	  -0.5, 0.5, 0.8, -0.8, 0.5, 0.5, -0.8, 0.5,-0.5, -0.5, 0.5,-0.8   /*  12, 13, 14, 15  */
	  };
	static char poo[] = {
	   0, 8, 1,  1, 9, 2,  2,10, 3,  3,11, 4,  /*  side  */
	   4,12, 5,  5,13, 6,  6,14, 7,  7,15, 0,
	  15, 8, 0,  8, 9, 1,  9,10, 2, 10,11, 3,
	  11,12, 4, 12,13, 5, 13,14, 6, 14,15, 7,
	   0, 1, 2,  2, 3, 4,  4, 5, 6,  6, 7, 0,  0, 2, 4,  4, 6, 0,  /*  top  */
	   8,15,14, 14,13,12, 12,11,10, 10, 9, 8,  8,14,12, 12,10, 8   /*  bottom  */
	  };
	static TQ3Param2D UV[3] = { 0 };
	TQ3Vertex3D vertex[3] = { 0 };
	TQ3MeshVertex meshVertices[3] = { 0 };
	TQ3GeometryObject mesh = { 0 };
	TQ3AttributeSet verticeAttr = { 0 };
	TQ3AttributeSet faceAttr = { 0 };
	TQ3MeshFace meshFace = { 0 };
	struct OpaqueTQ3Object *model = 0;    /*  TQ3GroupObject  */
	TQ3ColorRGB meshColor;
	float height, radius;
	short i, j, face, nfaces;

	/*  check that cylinder parameters define a positive volume  */
	height = ((struct VN_Cylinder *) node)->height;
	if (height <= 0.0)
		goto exit;
	radius = ((struct VN_Cylinder *) node)->radius;
	if (radius <= 0.0)
		goto exit;
	if ((node->flags & VNF_CYLINDER_TOP + VNF_CYLINDER_BOTTOM + VNF_CYLINDER_SIDE) == 0)
		goto exit;
	/*  allocate group object  */
	if (!(model = Q3DisplayGroup_New()))
		goto exit;
	/*  allocate mesh  */
	if (!(mesh = Q3Mesh_New())) {
exitmo:	Q3Object_Dispose(model);
		model = 0;
		goto exit;
		}
	/*  block update access to mesh  */
	if ((statusQD3D = Q3Mesh_DelayUpdates(mesh)) == kQ3Failure)
		goto exitmomesh;
	meshColor.r = (Random() + 32768) / 65535.0;
	meshColor.g = (Random() + 32768) / 65535.0;
	meshColor.b = (Random() + 32768) / 65535.0;
	/*  16 faces for cylinder side  */
	nfaces = 28;
	for (face = 0, j = 0; face < nfaces; face++, j += 3) {
		if (j < 48) {
			if ((node->flags & VNF_CYLINDER_SIDE) == 0)
				continue;
			}
		else if (j < 66) {
			if ((node->flags & VNF_CYLINDER_TOP) == 0)
				continue;
			}
		else {
			if ((node->flags & VNF_CYLINDER_BOTTOM) == 0)
				continue;
			}
		for (i = 0; i < 3; i++) {
			vertex[i].point.x = point[poo[i + j]].x * radius;
			vertex[i].point.y = point[poo[i + j]].y * height;
			vertex[i].point.z = point[poo[i + j]].z * radius;
			meshVertices[i] = Q3Mesh_VertexNew(mesh, &vertex[i]);
			if (!meshVertices[i]) {
exitmomesh:		Q3Object_Dispose(model);  //  error?
				model = 0;
				goto exitmesh;
				}
			verticeAttr = Q3AttributeSet_New();  //  error?
			Q3AttributeSet_Add(verticeAttr, kQ3AttributeTypeSurfaceUV, &UV[i]);  //  error?
			Q3Mesh_SetVertexAttributeSet(mesh, meshVertices[i], verticeAttr);  //  error?
			Q3Object_Dispose(verticeAttr);  //  error?
			}
		faceAttr = Q3AttributeSet_New();  //  error?
//		meshColor.r = (Random() + 32768) / 65535.0;
//		meshColor.g = (Random() + 32768) / 65535.0;
//		meshColor.b = (Random() + 32768) / 65535.0;
		Q3AttributeSet_Add(faceAttr, kQ3AttributeTypeDiffuseColor, &meshColor);  //  error?
		meshFace = Q3Mesh_FaceNew(mesh, 3, meshVertices, faceAttr);  //  error?
		Q3Object_Dispose(faceAttr);
		}
	Q3Mesh_ResumeUpdates(mesh);  //  error?
	Q3Group_AddObject(model, mesh);  //  error?
exitmesh:
	Q3Object_Dispose(mesh);
exit:
	return (model);
	}
	

struct OpaqueTQ3Object *InitFaceModel(struct VN_IndexedFaceSet *node) {
/*  return *model if successful  */
	struct VN_Coordinate *coordNode;
	struct OpaqueTQ3Object *model = 0;    /*  TQ3GroupObject  */
	TQ3GeometryObject mesh = { 0 };
	TQ3MeshVertex meshVertices[3] = { 0 };
	TQ3Vertex3D vertex[3] = { 0 };
	TQ3AttributeSet verticeAttr = { 0 };
	TQ3AttributeSet faceAttr = { 0 };
	TQ3MeshFace meshFace = { 0 };
	TQ3ColorRGB meshColor;
//	struct VDT_VEC3F vec3f;
	VDT_INT32 int32;
	short i, j;

	/*  allocate group object  */
	if (!(model = Q3DisplayGroup_New()))
		goto exit;
	/*  allocate mesh  */
	if (!(mesh = Q3Mesh_New()))
		goto exitmo;
	/*  block update access to mesh  */
	if ((statusQD3D = Q3Mesh_DelayUpdates(mesh)) == kQ3Failure) {
exitmesh:
		Q3Object_Dispose(mesh);
exitmo:	Q3Object_Dispose(model);
		model = 0;
		goto exit;
		}
	if ((node->coord) && (coordNode = (struct VN_Coordinate *) node->coord->node)) {
		/*  dump point triplets to log window  */
		
		
//		for (i = 0; i < coordNode->npoints; i++) {
//			vec3f.x = coordNode->point[i].x * 100.0;
//			vec3f.y = coordNode->point[i].y * 100.0;
//			vec3f.z = coordNode->point[i].z * 100.0;
//			lwprintf(&statDoc, "\n%d,%d,%d [%d]", (short) vec3f.x, (short) vec3f.y, (short) vec3f.z, i);
//			}
		/*  The use of mesh geometries are a bit different from other geometries  */
		/*  in that adding a vertex or face to the mesh does not increment it's   */
		/*  reference count.  So there's no need to dispose these entities.       */
		/*  - Robert Dierkes  */
		/*  dump points to log window  */
		meshColor.r = (Random() + 32768) / 65535.0;
		meshColor.g = (Random() + 32768) / 65535.0;
		meshColor.b = (Random() + 32768) / 65535.0;
		j = 0;
		for (i = 0; i < node->ncoordIndexs; i++) {
			int32 = node->coordIndex[i];
			if (int32 >= 0) {
				vertex[j % 3].point.x = coordNode->point[int32].x;
				vertex[j % 3].point.y = coordNode->point[int32].y;
				vertex[j % 3].point.z = coordNode->point[int32].z;
				if (j > 2) {
//	not needed?		Q3Object_Dispose(meshVertices[(j - 2) % 3]);
					meshVertices[(j - 2) % 3] = meshVertices[j % 3];
					}
				meshVertices[j % 3] = Q3Mesh_VertexNew(mesh, &vertex[j % 3]);
				if (!meshVertices[j % 3])
					goto exitmesh;
//				verticeAttr = Q3AttributeSet_New();  //  error?
//				Q3AttributeSet_Add(verticeAttr, kQ3AttributeTypeSurfaceUV, &UV[i]);  //  error?
//				Q3Mesh_SetVertexAttributeSet(mesh, meshVertices[j], verticeAttr);  //  error?
//				Q3Object_Dispose(verticeAttr);  //  error?
//				if (j == 0) {
				if (j) {
//					lwprintf(&statDoc, "\n%ld", (long) int32);
//					}
//				else {
//					lwprintf(&statDoc, " %ld", (long) int32);
					if (j > 1) {
//						meshColor.r = (Random() + 32768) / 65535.0;
//						meshColor.g = (Random() + 32768) / 65535.0;
//						meshColor.b = (Random() + 32768) / 65535.0;
						faceAttr = Q3AttributeSet_New();  //  error?
						Q3AttributeSet_Add(faceAttr, kQ3AttributeTypeDiffuseColor, &meshColor);  //  error?
						meshFace = Q3Mesh_FaceNew(mesh, 3, meshVertices, faceAttr);  //  error?
						Q3Object_Dispose(faceAttr);
						}
					}
				j++;
				}
			else
				j = 0;
			}
		}
	Q3Mesh_ResumeUpdates(mesh);  //  error?
	Q3Group_AddObject(model, mesh);  //  error?
	Q3Object_Dispose(mesh);
exit:
	return (model);
	}  /*  InitFaceModel()  */


void model(struct VN_Nod *node, short method) {
	TQ3Vector3D vector3D;
	TQ3Matrix4x4 xform_a, xform_b, xform_c;
	struct TQ3RotateAboutAxisTransformData AxisTransform;
	TQ3DisplayGroupState state;

	/*  Each node can have a model assigned to it.  A model is a
	/*  pre-built dataset that can be submitted directly for 3D rendering
	/*  to screen.  As nodes are parsed, a node's model may need to
	/*  be referenced by its children without being completely pre-built.
	/*  Since node children only refer to their parent node's model and
	/*  not it's contents, the actual content of a model can be built in
	/*  two passes.  Initialization, the first pass, creates an empty
	/*  instance of the model which is sufficient in case children nodes
	/*  need to reference it.  Build, the second pass, completes
	/*  creating content that will be contained by the model after
	/*  the node and all its children have been parsed.  */
	switch (node->type) {
	  case VNT_INDEXEDFACESET:
		if (method == MODEL_BUILD) {
			node->model = InitFaceModel((struct VN_IndexedFaceSet *) node);
			}
		break;
	  case VNT_CYLINDER:
		if (method == MODEL_BUILD) {
			node->model = InitCylinderModel(node);
			}
		break;
	  case VNT_BOX:
		if (method == MODEL_BUILD) {
			node->model = InitBoxModel(node);
			}
		break;
	  case VNT_TRANSFORM0:
		if (method == MODEL_INIT) {
			node->model = Q3DisplayGroup_New();
//			vector3D.x = vector3D.y = vector3D.z = 0.0;
//			((struct VN_Transform *) node)->xform = Q3TranslateTransform_New(&vector3D);
			Q3Matrix4x4_SetTranslate(&xform_a, 0.0, 0.0, 0.0);
			((struct VN_Transform0 *) node)->xform_m = Q3MatrixTransform_New(&xform_a);
			Q3Group_AddObject(node->model, ((struct VN_Transform0 *) node)->xform_m);
			}
		else if (method == MODEL_BUILD) {
			vector3D.x = ((struct VN_Transform0 *) node)->translation.x;
			vector3D.y = ((struct VN_Transform0 *) node)->translation.y;
			vector3D.z = ((struct VN_Transform0 *) node)->translation.z;
			lwprintf(&statDoc, "\nxform %ld,%ld,%ld",
			  (long) (vector3D.x * 100.0),
			  (long) (vector3D.y * 100.0),
			  (long) (vector3D.z * 100.0));
			Q3Matrix4x4_SetTranslate(&xform_a, vector3D.x, vector3D.y, vector3D.z);
//			Q3TranslateTransform_Set(((struct VN_Transform *) node)->xform0, &vector3D);
			Q3MatrixTransform_Set(((struct VN_Transform0 *) node)->xform_m, &xform_a);
			/*  now do rotate  */
			AxisTransform.origin.x = AxisTransform.origin.y = AxisTransform.origin.z = 0.0;
			AxisTransform.orientation.x = ((struct VN_Transform0 *) node)->rotation.x;
			AxisTransform.orientation.y = ((struct VN_Transform0 *) node)->rotation.y;
			AxisTransform.orientation.z = ((struct VN_Transform0 *) node)->rotation.z;
			AxisTransform.radians = ((struct VN_Transform0 *) node)->rotation.r;
			if (AxisTransform.radians != 0.0) {
				if ((AxisTransform.orientation.x != 0.0) ||
				  (AxisTransform.orientation.y != 0.0) ||
				  (AxisTransform.orientation.z != 0.0)) {
					Q3Matrix4x4_SetRotateAboutAxis(&xform_b, &AxisTransform.origin, &AxisTransform.orientation, AxisTransform.radians);
//  if (kQ3Failure == Q3MatrixTransform_Get(((struct VN_Transform *) node)->xform0, &xform_a))  //  error?
//						goto rskip;
					Q3Matrix4x4_Multiply(&xform_b, &xform_a, &xform_c);
if (kQ3Failure == Q3MatrixTransform_Set(((struct VN_Transform0 *) node)->xform_m, &xform_c))  //  error?
						goto rskip;
					lwprintf(&statDoc, "\nrotate %ld,%ld,%ld %ld",
					  (long) (AxisTransform.orientation.x * 100.0),
					  (long) (AxisTransform.orientation.y * 100.0),
					  (long) (AxisTransform.orientation.z * 100.0),
					  (long) (AxisTransform.radians * 100.0));
					}
				else
					goto rskip;
				}
			else
rskip:			lwprintf(&statDoc, "\nrotate -none-");
			}
		break;
	  case VNT_GROUP:
		if (method == MODEL_INIT) {
			node->model = Q3DisplayGroup_New();  // error?
			}
		break;
	  case VNT_SHAPE:
		if (method == MODEL_INIT) {
			node->model = Q3DisplayGroup_New();
			/*  xform state not changed, so disable push/pop of group state  */
			Q3DisplayGroup_GetState(node->model, &state);
			Q3DisplayGroup_SetState(node->model, state | kQ3DisplayGroupStateMaskIsInline);
			}
		break;
	  case VNT_ROOT:
		if (method == MODEL_INIT)
			node->model = Q3DisplayGroup_New();
		}
	}


void modelAdd(struct VN_NodeLink *nodelink, struct VN_Nod *node) {
	struct VN_Nod *groupnode;

	groupnode = nodelink->node;
	if (groupnode->model) {
		switch (groupnode->type) {
		  case VNT_SHAPE:
		  case VNT_ROOT:
		  case VNT_TRANSFORM0:
		  case VNT_GROUP:
			Q3Group_AddObject(groupnode->model, node->model);
			}
		}
	}


/*  DisposeModel  */
/*  why isn't this just another method ... of model() ?  */
void DisposeModels(struct VN_Nod *node, short mode) {  // error?

	if (mode)
		Q3Object_Dispose((struct OpaqueTQ3Object *) node);
	else {
		if (node->model)
			Q3Object_Dispose(node->model);
		switch (node->type) {
		  case VNT_TRANSFORM0:
			if (((struct VN_Transform0 *) node)->xform_m)
				Q3Object_Dispose(((struct VN_Transform0 *) node)->xform_m);
			}
		}
	}
