/*	zap technologies - copyright 1999
/*	http://www.zaptech.com
/*
/*  This file contains most of the model new, load, and save code and
/*  the per frame rendering code.
/*  Load and save are currently written to perform file processing a
/*  few characters at a time.  This is so that the main event
/*  loop can stay alive to allow commands, rendering, and multiple views.
/*
/*  tweaks to do - clean up add() code that calls vrml(..., CHILDADD, 0) ?
/*
/*  1999-11-02 - now parses ROUTES embedded in nodes
/*  1999-10-24 - enhanced node name parsing to accomodate tight {
/*  1999-09-29 - adjusted default fill light to behave as headlamp
/*  1999-09-27 - DEF / USE traversal of nodes.  Also now parses by unsupported
/*               DEF / USE nodes
/*  1999-09-05 - consolidated end of node (aka '}') parsing code
/*               added ending multinode ']' handling
/*  1999-09-01 - added dynamic node->define string pre-allocation
/*               enhanced define string to accept - and _  Fixed multi numeric
/*               array parsing to properly end with tight ] sufix
/*  1999-04-17 - charsPerPass now makes access faster
/*  1999-04-04 - forked from models.c
/*
/*  Note:
/*  - most routines return 0 if an error occurs
/*  - many routines will set global string pointer errorMsg
/*    if they encounter an error
*/

/*  headers  */
#include <MacTypes.h>
#include <Controls.h>
#include <Errors.h>
#include <QD3D.h>
#include <QD3DDrawContext.h>
#include <QD3DCamera.h>
#include <QD3DLight.h>
#include <QD3DView.h>
#include <QD3DRenderer.h>
#include <QD3DMath.h>
#include <QD3DGroup.h>
#include <QD3DShader.h>
#include <QD3DGeometry.h>
#include <QD3DTransform.h>

#include "vrml.h"
#define H_PARSE_PROTOS
#include "parse.h"
#undef H_PARSE_PROTOS
#define H_MODEL_PROTOS
#include "models.h"
#undef H_MODEL_PROTOS
// #define H_TWIRL_TV  // debug only ?
#include "twirl.h"
// #undef H_TWIRL_TV
#include "myio.h"


/*  local function prototypes  */
short New3dView(struct docWindowView *doc);
TQ3Status drawOrigin(TQ3ViewObject view);
void traverse(struct VN_NodeLink *nodelink, TQ3ViewObject view);/*
void traverseOld(struct VN_Nod *node, TQ3ViewObject view);*/
int MatchNode(struct docWindowView *doc);
int matchField(struct fileBufRec0 *bufRec);
short add(struct fileBufRec0 *bufRec, char type);
short use(struct fileBufRec0 *bufRec, struct VN_NodeLink *rootLink);
struct VN_Nod *traverseLink(struct VN_NodeLink *nodeLink, char *use);
char *AllocValueArrayPtr(Handle Hdl, long size);/*
Handle AllocValueArrayHandle();


/*  external global variables  */
extern char *errorMsg;
extern short flags;
extern wprintDocument statDoc;
extern TQ3Status statusQD3D;
extern struct VN_FIELDDATATYPEINFO fieldTypeInfo[];
extern struct VN_STRUCTINFO nodeInfo[];


/*  global variables  */
long charsPerPass = CHARSPERPASS_DEFAULT;


/*  Init 3D Window  */
/*  create dummy (non-VRML) twirl instance containing some random 3D content */
int Init3dView(struct docWindowView *doc) {
	int success = 0;

	/*  register new view context area  */
	if (New3dView(doc) == 0)
		goto exit;
	/*  -- create randomized model --  */
	doc->flags |= (Random() & 1) * TVF_REFLINES;
	if (Random() & 1) {
		if (!(doc->twirl.model = Init4boxModel())) {
			errorMsg = "Init4boxModel() failed";
			goto xview;
			}
		}
	else {
		if (!(doc->twirl.model = InitMeshModel())) {
			errorMsg = "InitMeshModel() failed";
xview:		Q3Object_Dispose(doc->twirl.view);
			goto exit;
			}
		}
	success = 1;
exit:
	return (success);
	}  /* Init3dView()  */


/*  This routine allocates doc->twirl.view and then configures it with
/*  some necessary QD3D view parameters ...
/*    twirl.view:
/*      drawcontext =.
/*        double buffered, white background enabled, no mask, 
/*        render pane set to default window according to twirl.flags
/*      renderer = interactive
/*      camera (Angle Aspect Ratio perspective type) =
/*        FOV 90 degrees, aspect ratio same as current window size,
/*        position 0,0,7, interest 0,0,0, hither/yon 0.001/1000,
/*        up 0,1,0, viewport origin/size -1,1/2,2
/*      light = ambient + point + fill
/*    twirl.interpolation style = none
/*    twirl.backFacing style = draw only front sides
/*    twirl.fillStyle = fill
/*    twirl.shader = phong
/*    twirl.rotation = identity matrix  */
short New3dView(struct docWindowView *doc) {
	TQ3MacDrawContextData macDrawContextData;
	TQ3DrawContextObject drawContext;
	TQ3RendererObject renderer;
	TQ3ViewAngleAspectCameraData cameraData;
	TQ3CameraObject camera;
	TQ3LightData lightData;
	TQ3PointLightData lightDataPoint;
	TQ3DirectionalLightData	lightDataFill;
	TQ3LightObject ambientLight, pointLight, fillLight;
	TQ3GroupObject lightList;
	TQ3GroupPosition groupPosition;
	int lightok = 0;
	short success = 0;

	/*  register new view context area  */
	if (!(doc->twirl.view = Q3View_New())) {
		errorMsg = "QD3DView_New() failed";
		goto x;
		}
	if (flags & F_LOG)
		if (statDoc.winPtrx) wprintf(&statDoc, "\n3D QD3DView_New() successful");
	/*  -- create draw context data --  */
	macDrawContextData.drawContextData.clearImageMethod = kQ3ClearMethodWithColor;
	macDrawContextData.drawContextData.clearImageColor.a = 1.0;
	macDrawContextData.drawContextData.clearImageColor.r = 1.0;
	macDrawContextData.drawContextData.clearImageColor.g = 1.0;
	macDrawContextData.drawContextData.clearImageColor.b = 1.0;
	if (doc->twirl.flags & TF_SHOWCTRLS)
		macDrawContextData.drawContextData.paneState = kQ3True;
	else
		macDrawContextData.drawContextData.paneState = kQ3False;
	macDrawContextData.drawContextData.pane.min.x = doc->twirl.pane0.left;
	macDrawContextData.drawContextData.pane.min.y = doc->twirl.pane0.top;
	macDrawContextData.drawContextData.pane.max.x = doc->twirl.pane0.right;
	macDrawContextData.drawContextData.pane.max.y = doc->twirl.pane0.bottom;
	macDrawContextData.drawContextData.maskState = kQ3False;
	macDrawContextData.drawContextData.doubleBufferState = kQ3True;
	macDrawContextData.drawContextData.clearImageMethod = kQ3ClearMethodWithColor;
	macDrawContextData.library = kQ3Mac2DLibraryNone;
	macDrawContextData.viewPort = nil;
	macDrawContextData.grafPort = nil;
	macDrawContextData.window = (CGrafPtr) doc->winPtr;
	if (!(drawContext = Q3MacDrawContext_New(&macDrawContextData))) {
		errorMsg = "3D QDMacDrawContext_New() failed";
		goto xview;
		}
	statusQD3D = Q3View_SetDrawContext(doc->twirl.view, drawContext);
	/*  dispose draw context data  */
	Q3Object_Dispose(drawContext);
	if (statusQD3D == kQ3Failure) {
		errorMsg = "3D Q3View_SetDrawContext() failed";
		goto xview;
		}
	if (flags & F_LOG)
		if (statDoc.winPtrx) wprintf(&statDoc, "\n3D Q3View_SetDrawContext() successful");
	/*  -- create renderer --  */
//	if (!(renderer = Q3Renderer_NewFromType(kQ3RendererTypeWireFrame))) {
	if (!(renderer = Q3Renderer_NewFromType(kQ3RendererTypeInteractive))) {
		errorMsg = "3D Q3Renderer_NewFromType() failed";
		goto xview;
		}
	/*  Use the best possible renderer  */
//  myStatus = Q3InteractiveRenderer_SetDoubleBufferBypass(renderer, kQ3True);						
//  myStatus = Q3InteractiveRenderer_SetPreferences(renderer, kQAVendor_BestChoice, 0);
	statusQD3D = Q3View_SetRenderer(doc->twirl.view, renderer);
	Q3Object_Dispose(renderer);
	if (statusQD3D == kQ3Failure) {
		errorMsg = "3D Q3View_SetRenderer() failed";
		goto xview;
		}
	if (flags & F_LOG)
		if (statDoc.winPtrx) wprintf(&statDoc, "\n3D Q3View_SetRenderer() successful");
	/*  -- create camera --  */
	cameraData.cameraData.placement.cameraLocation.x = 0.0;
	cameraData.cameraData.placement.cameraLocation.y = 0.0;
	cameraData.cameraData.placement.cameraLocation.z = VN_Viewpoint_defaultz;
	cameraData.cameraData.placement.pointOfInterest.x = 0.0;
	cameraData.cameraData.placement.pointOfInterest.y = 0.0;
	cameraData.cameraData.placement.pointOfInterest.z = 0.0;
	cameraData.cameraData.placement.upVector.x = 0.0;
	cameraData.cameraData.placement.upVector.y = 1.0;
	cameraData.cameraData.placement.upVector.z = 0.0;
	cameraData.cameraData.range.hither = 0.001;
	cameraData.cameraData.range.yon = 1000.0;
	cameraData.cameraData.viewPort.origin.x = -1.0;
	cameraData.cameraData.viewPort.origin.y = 1.0;
	cameraData.cameraData.viewPort.width = 2.0;
	cameraData.cameraData.viewPort.height = 2.0;
	cameraData.fov = Q3Math_DegreesToRadians(VN_Viewpoint_default_fov);
	cameraData.aspectRatioXToY	=
		(float) (doc->winPtr->portRect.right - doc->winPtr->portRect.left) / 
		(float) (doc->winPtr->portRect.bottom - doc->winPtr->portRect.top);
	if (!(camera = Q3ViewAngleAspectCamera_New(&cameraData))) {
		errorMsg = "3D Q3ViewAngleAspectCamera_New() failed";
		goto xview;
		}
	statusQD3D = Q3View_SetCamera(doc->twirl.view, camera);
	/*  dispose camera data  */
	Q3Object_Dispose(camera);
	if (statusQD3D == kQ3Failure) {
		errorMsg = "3D Q3View_SetCamera() failed";
		goto xview;
		}
	if (flags & F_LOG)
		if (statDoc.winPtrx) wprintf(&statDoc, "\n3D Q3View_SetCamera() successful");
	/*  -- create light data: ambient --  */
	lightData.isOn = kQ3True;
	lightData.color.r = 1.0;
	lightData.color.g = 1.0;
	lightData.color.b = 1.0;
	lightData.brightness = 0.2;
	if (!(ambientLight = Q3AmbientLight_New(&lightData))) {
		errorMsg = "3D Q3AmbientLight_New() failed";
		goto xview;
		}
	/*  -- create light data: point --  */
	lightDataPoint.lightData = lightData;
	lightDataPoint.lightData.brightness = 1.0;
	lightDataPoint.castsShadows = kQ3False;
	lightDataPoint.attenuation = kQ3AttenuationTypeNone;
	lightDataPoint.location.x = -10.0;
	lightDataPoint.location.y =   0.0;
	lightDataPoint.location.z =  10.0;
	if (!(pointLight = Q3PointLight_New(&lightDataPoint))) {
		errorMsg = "3D Q3PointLight_New() failed";
		goto xambnt;
		}
	/*  -- create light data: fill --  */
	lightDataFill.lightData = lightData;
	lightDataFill.lightData.brightness = 1.0;
	lightDataFill.castsShadows = kQ3False;
	lightDataFill.direction.x = 0.0;
	lightDataFill.direction.y =  0.0;
	lightDataFill.direction.z = -10.0;
	if (!(fillLight = Q3DirectionalLight_New(&lightDataFill))) {
		errorMsg = "3D Q3DirectionalLight_New() Fill failed";
		goto xpoint;
		}
	/*  -- create light data: list --  */
	if (lightList = Q3LightGroup_New()) {
		if (groupPosition = Q3Group_AddObject(lightList, ambientLight)) {
			if (groupPosition = Q3Group_AddObject(lightList, pointLight)) {
				if (groupPosition = Q3Group_AddObject(lightList, fillLight)) {
					statusQD3D = Q3View_SetLightGroup(doc->twirl.view, lightList);
					if (statusQD3D != kQ3Failure) {
						if (flags & F_LOG)
							if (statDoc.winPtrx) wprintf(&statDoc, "\nQ3View_SetLightGroup() successful");
						lightok = 1;
						}
					else errorMsg = "3D Q3View_SetLightGroup() failed";
					}
				else errorMsg = "3D Q3Group_AddObject() Fill failed";
				}
			else errorMsg = "3D Q3Group_AddObject() Point failed";
			}
		else errorMsg = "3D Q3Group_AddObject() Ambient failed";
		/*  dispose light data: list  */
		Q3Object_Dispose(lightList);
		}
		/*  dispose light data: fill, point, ambient  */
		Q3Object_Dispose(fillLight);
xpoint:	Q3Object_Dispose(pointLight);
xambnt:	Q3Object_Dispose(ambientLight);
		if (!lightok)	/*  bail if any problems setting up lights  */
			goto xview;
		/*  --  --  */
	if (!(doc->twirl.interpolation = Q3InterpolationStyle_New(kQ3InterpolationStyleNone))) {
		errorMsg = "Q3InterpolationStyle_New() failed";
		goto xview;
		}
	//	if (!(vp->backFacing = Q3BackfacingStyle_New(kQ3BackfacingStyleBoth))) {
	if (!(doc->twirl.backFacing = Q3BackfacingStyle_New(kQ3BackfacingStyleRemove))) {
		errorMsg = "Q3BackfacingStyle_New() failed";
		goto xview;
		}
	if (!(doc->twirl.fillStyle = Q3FillStyle_New(kQ3FillStyleFilled))) {
		errorMsg = "Q3FillStyle_New() failed";
		goto xview;
		}
	if (!(doc->twirl.shader = Q3PhongIllumination_New())) {
		errorMsg = "Q3PhongIllumination_New() error";
xview:	Q3Object_Dispose(doc->twirl.view);
		goto x;
		}
	/*  rotation matrix = identity  */
	Q3Matrix4x4_SetIdentity(&doc->twirl.rotation);
	if (flags & F_LOG)
		if (statDoc.winPtrx) wprintf(&statDoc,
		  "\nUse arrow , . keys to spin view point\nS]tudy  R]otate");
	success = 1;
x:	return (success);
	}


moveCamera(struct twirlRec *twirl, short method) {
	TQ3CameraObject camera;
	TQ3CameraPlacement pos;
	struct OpaqueTQ3Object *draw;  /*  TQ3DrawContextObject  */
	TQ3Matrix4x4 xform;
	static TQ3Vector3D up = {    0.0,  1.0,  0.0 };
	static TQ3Vector3D ahead = { 0.0,  0.0, -1.0 };
	static TQ3Point3D origin = { 0.0,  0.0,  0.0 };
	short x, y, z;
	short success = 0;

	if  (method == TVC_PANE) {
		/*  at this point twirl->pane must already be set
		/*  to 3D pane size prior to calling moveCamera()  */
		Q3View_GetDrawContext(twirl->view, &draw);  /*  remember to dipose this!  */
		if (twirl->flags & TF_SHOWCTRLS) {
			Q3DrawContext_SetPaneState(draw, kQ3True);
			((TQ3Area *) &xform)->min.y = twirl->pane0.top;
			((TQ3Area *) &xform)->max.y = twirl->pane0.bottom;
			((TQ3Area *) &xform)->min.x = twirl->pane0.left;
			((TQ3Area *) &xform)->max.x = twirl->pane0.right;
			Q3DrawContext_SetPane(draw, (TQ3Area *) &xform);
			}
		else
			Q3DrawContext_SetPaneState(draw, kQ3False);
		Q3Object_Dispose(draw);  /*  dispose here or leak memory!  */
		goto x;
		}
	Q3View_GetCamera(twirl->view, &camera);
	Q3Camera_GetPlacement(camera, &pos);
	switch (method) {
	  case TVC_PULLBACK:
		twirl->px -= twirl->ax;
		twirl->py -= twirl->ay;
		twirl->pz -= twirl->az;
		goto set;
	  case TVC_APPROACH:
		twirl->px += twirl->ax;
		twirl->py += twirl->ay;
		twirl->pz += twirl->az;
		goto set;
	  case TVC_SET:
		/*  calculate view xform and rotated ax,ay,az vector  */
		Q3Matrix4x4_SetRotateAboutAxis(&xform, &origin, (struct TQ3Vector3D *) &(twirl->ox), twirl->or);
		Q3Vector3D_Transform(&ahead, &xform, (struct TQ3Vector3D *) &(twirl->ax));
//		lwprintf(&statDoc, "\n pi %d,%d,%d %d",
//		  (short) (twirl->ax * 1000.0), (short) (twirl->ay * 1000.0),
//		  (short) (twirl->az * 1000.0), (short) (twirl->or * 1000.0));
set:	pos.cameraLocation.x =  twirl->px;
		pos.pointOfInterest.x = twirl->px + twirl->ax;
		pos.cameraLocation.y =  twirl->py;
		pos.pointOfInterest.y = twirl->py + twirl->ay;
		pos.cameraLocation.z =  twirl->pz;
		pos.pointOfInterest.z = twirl->pz + twirl->az;
		Q3Camera_SetPlacement(camera, &pos);
		Q3View_SetCamera(twirl->view, camera);
//		lwprintf(&statDoc, "\n vp %d,%d,%d", (short) twirl->px, (short) twirl->py, (short) twirl->pz);
		success = 1;
		break;
	  case TVC_LOG:
		x = pos.cameraLocation.x;
		y = pos.cameraLocation.y;
		z = pos.cameraLocation.z;
		lwprintf(&statDoc, "\nCamera [%2d,%2d,%2d]", x, y, z);	
		lwprintf(&statDoc, "\n       [%2d,%2d,%2d]", (short) twirl->px, (short) twirl->py, (short) twirl->pz);
x:		success = 1;
		break;
	  default:
		errorMsg = "moveCamera(): unknown method";	
		break;
		}
	return (success);
	}  /*  moveCamera()  */


/*  Caution: Does not check (doc->view) != NULL  */
TQ3Status drawOrigin(TQ3ViewObject view) {
	static TQ3Vertex3D polyineVertices[8] = {
		{{ 6.0,  0.0,  0.0}, 0},
		{{ 0.5,  0.0,  0.0}, 0},
		{{-0.5,  0.0,  0.0}, 0},
		{{-6.0,  0.0,  0.0}, 0},
		{{ 0.0,  6.0,  0.0}, 0},
		{{ 0.0,  0.5,  0.0}, 0},
		{{ 0.0, -0.5,  0.0}, 0},
		{{ 0.0, -6.0,  0.0}, 0}
		};
	TQ3PointData point = { 0 };
	TQ3PolyLineData polyline = { 0 };
	TQ3Status status;

	/*  setup & submit points, immediate mode  */
	Q3Point3D_Set(&point.point, 0.5, 0.5,  0.5);
	status = Q3Point_Submit(&point, view);
	Q3Point3D_Set(&point.point, 0.5, 0.5, -0.5);
	status = Q3Point_Submit(&point, view);
	Q3Point3D_Set(&point.point, 0.5,-0.5,  0.5);
	status = Q3Point_Submit(&point, view);
	Q3Point3D_Set(&point.point, 0.5,-0.5, -0.5);
	status = Q3Point_Submit(&point, view);
	Q3Point3D_Set(&point.point,-0.5, 0.5,  0.5);
	status = Q3Point_Submit(&point, view);
	Q3Point3D_Set(&point.point,-0.5, 0.5, -0.5);
	status = Q3Point_Submit(&point, view);
	Q3Point3D_Set(&point.point,-0.5,-0.5,  0.5);
	status = Q3Point_Submit(&point, view);
	Q3Point3D_Set(&point.point,-0.5,-0.5, -0.5);
	status = Q3Point_Submit(&point, view);
	/*  setup & submit polylines, immediate mode  */
	polyline.numVertices = 2;
	polyline.vertices = polyineVertices;
	status = Q3PolyLine_Submit(&polyline, view);
	polyline.vertices = &polyineVertices[2];
	status = Q3PolyLine_Submit(&polyline, view);
	polyline.vertices = &polyineVertices[4];
	status = Q3PolyLine_Submit(&polyline, view);
	polyline.vertices = &polyineVertices[6];
	status = Q3PolyLine_Submit(&polyline, view);
	return (status);
	}  /*  drawOrigin()  */


Twirl(struct docWindowView *doc, short method) {
	short success = 0;

	//  methods so far
	//	TWIRL_VIEWNEW   create empty twirl instance
	//	TWIRL_DRAW      perform a single render pass of a twirl instance
	//                  standard QD3D interative draw loop with 3D origin cross hairs.
	//	TWIRL_DISPOSE   dispose twirl instance
	switch (method) {
	  case TWIRL_VIEWNEW:
		if (success = New3dView(doc)) {
			doc->twirl.pz = VN_Viewpoint_defaultz;
			doc->twirl.az = -1.0;
			}
		break;
	  case TWIRL_DRAW:
		Q3View_StartRendering(doc->twirl.view);  /*  (doc->view) == NULL?  */
		do {
			if (doc->twirl.interpolation)
				Q3Style_Submit(doc->twirl.interpolation, doc->twirl.view);
			if (doc->twirl.backFacing)
				Q3Style_Submit(doc->twirl.backFacing, doc->twirl.view);
			if (doc->twirl.fillStyle)
				Q3Style_Submit(doc->twirl.fillStyle, doc->twirl.view);
			if (doc->twirl.shader)
				Q3Shader_Submit(doc->twirl.shader, doc->twirl.view);
			Q3MatrixTransform_Submit(&doc->twirl.rotation, doc->twirl.view);
			/*  submit model or vrml (not both), retained mode  */
			if (doc->twirl.model)
				Q3DisplayGroup_Submit(doc->twirl.model, doc->twirl.view);  //  error?
			else if (doc->vrml)
				traverse(doc->vrml, doc->twirl.view);  //  error?
//				traverse(((struct VN_Root *) doc->vrml)->nodes, doc->twirl.view);  //  error?
			/*  submit origin marker, immediate mode  */
			if (doc->flags & TVF_REFLINES)
				drawOrigin(doc->twirl.view);  //  error?
			} while (Q3View_EndRendering(doc->twirl.view) == kQ3ViewStatusRetraverse);
		break;
	  case TWIRL_DISPOSE:
		if (doc->twirl.interpolation) Q3Object_Dispose(doc->twirl.interpolation);
		if (doc->twirl.backFacing)    Q3Object_Dispose(doc->twirl.backFacing);
		if (doc->twirl.fillStyle)     Q3Object_Dispose(doc->twirl.fillStyle);
		if (doc->twirl.model)         DisposeModels((struct VN_Nod *) doc->twirl.model, 1);
		if (doc->twirl.shader)        Q3Object_Dispose(doc->twirl.shader);
		if (doc->twirl.view)          Q3Object_Dispose(doc->twirl.view);
		/*  controls are disposed of authomatically by DisposeWindow?  */
		if (doc->twirl.viewPrevButtonHdl)
			DisposeControl(doc->twirl.viewPrevButtonHdl);
		if (doc->twirl.viewNextButtonHdl)
			DisposeControl(doc->twirl.viewNextButtonHdl);
		}
exit:
	return (success);
	}  /*  Twirl()  */


void traverse(struct VN_NodeLink *nodelink, TQ3ViewObject view) {
	struct VN_Nod *node;

	if (node = nodelink->node) {
//		if (((struct VN_Root *) node)->views)
//			lwprintf(&statDoc, "\nview: %s",
//			  ((struct VN_Viewpoint *) ((struct VN_Root *) node)->views->node)->description);
		if (node->model)
			Q3DisplayGroup_Submit(node->model, view);  //  error?
		}
	}


/*  This is a recursive routine.
/*  Should only be called from within rendering loop!
void traverseOld(struct VN_Nod *node, TQ3ViewObject view) {
	struct VN_Nod **root;
	struct VN_Nod *child;
	short i, j;

	while (node) {
		if (node->flags & VNF_TRAVERSE) {
			/*  render model
			if (node->model) {
				Q3DisplayGroup_Submit(node->model, view);  //  error?
				i = 'M';
				}
			else
				i = '-';
			if ((flags & F_LOG) && statDoc.winPtrx)
			  wprintf(&statDoc, "\nnode: %s %c", nodeInfo[node->type].name, i);
			/*  decend into node children
			root = &node;
			i = 0;
			while (i < nodeInfo[node->type].fields) {
				/*  only traverse fields that may have children
				j = nodeInfo[node->type].fi[i].datatype;
				if ((j == VNDT_RESERVEDPTR) || (j > VNDT_MFNODE))
					break;
				if (child = root[i])
//					traverse(child, view);  //  error?
				i++;
				}
			}
//  ERROR!	node = node-> next;
		}
	}  /*  */


/*  Save 3D Window  */
int Save3dView(struct docWindowView *doc) {
	short success = 0;

  	if (flags & F_LOG)
		if (statDoc.winPtrx) wprintf(&statDoc, "\nSaving ...\n");
	if ((flags & F_LOG) && statDoc.winPtrx) {
		wprintf(&statDoc, "#VRML V2.0 utf8\n");
		wprintf(&statDoc, "#zap technologies - twirl " VERSIONSTR " %x \n", doc->flags);
		}
	success = 1;
exit:
	return (success);
	}


/*  Open 3D Window  */
int Open3dView(struct docWindowView *doc) {
	struct fileBufRec0 *bufRec;
	struct VN_Nod *node;
	char *tptr;
	long count;
	OSErr fileErr;
	short success = 0;
	short readpass = 0;  /*  allow more than one read pass before returning  */ 
	short i, j;
	char c;

	switch (doc->fileState) {
	  case TVFS_OPENREAD:
	  	/*  open file  */
		if (fileErr = FSpOpenDF(&doc->fileSpec, fsRdPerm, &doc->fileRN)) {
			errorMsg = "Open3dView(), FSpOpen() error";
			doc->fileState = TVFS_VOID;
			doc->flags &= ~(TVF_OPENING | TVF_NULLON);
			goto exit;
			}
		doc->fileState = TVFS_CLOSE;
		/*  Seek to Start of File  */
		fileErr = SetFPos(doc->fileRN, fsFromStart, 0);
		if (fileErr != noErr) {
			errorMsg = "Open3dView(), SetFPos() error";
			goto exit;
			}
		doc->fileBufRec->parseState = TVFSOP_NODEPRE;
		doc->fileBufRec->nodeLinkCurrent = doc->vrml;
		doc->fileBufRec->nodeLinkCurrent->node->field = VNT_ROOT_CHILDREN;
		doc->fileBufRec->nodeLinkCurrent->node->flags |= VNF_MULTINODE;
		/*  NewPtrClear() zeros these 
		doc->fileBufRec->flags = 0;
		doc->fileBufRec->bufi = 0;
		doc->fileBufRec->define = 0;  */
		doc->fileState = TVFS_READHEAD;
		/*  Root node already allocated, init its model here  */
		model(doc->vrml->node, MODEL_INIT);  //  error?
		success = 1;
		break;
	  case TVFS_READHEAD:
read:	count = 1;
		if (fileErr = FSRead(doc->fileRN, &count, &c)) {
			doc->fileState = TVFS_CLOSE;
			if (fileErr == eofErr)
				success = 1;
			else
				errorMsg = "Open3dView(), FSRead() error";
			goto exit;  // success = ?
			}
		bufRec = doc->fileBufRec;
		/*  skip comments till end of line  */
		if (doc->fileBufRec->flags & TO_COMMENT) {
			if ((c == '\n') || (c == '\r'))
				doc->fileBufRec->flags &= ~TO_COMMENT;
			goto exit;
			}
		if (c == '#') {
			bufRec->flags |= TO_COMMENT;
			goto exit;
			}
		switch (bufRec->parseState) {
		  case TVFSOP_NODEPRE:
			if ((c >= 'A') && (c <= 'Z')) {
				bufRec->parseState = TVFSOP_NODE;
				bufRec->buf[bufRec->bufi++] = c;
				}
			else if (c == '}')
				goto endnode;
			else if (c == ']') {
				node = bufRec->nodeLinkCurrent->node;  //  ERROR?
				if (node->flags & VNF_MULTINODE)
					bufRec->parseState = TVFSOP_FIELDPRE;
				}
			/*  else ignore white space  */
			success = 1;
			break;
		  case TVFSOP_NODE:
			if (((c >= 'a')  && (c <= 'z')) ||
			  ((c >= 'A') && (c <= 'Z')) ||
			  ((c >= '0') && (c <= '9')))
				bufRec->buf[bufRec->bufi++] = c;
			else {
				if (c == '{')
					bufRec->flags |= TO_STARTCHAR;
				else
					bufRec->flags &= ~TO_STARTCHAR;
				bufRec->buf[bufRec->bufi] = 0;
				bufRec->bufi = 0;
				if (!(MatchNode(doc)))
					goto readheaderr;
				}
			success = 1;
			break;
		  case TVFSOP_NODEDEFPRE:
			if (((c >= 'a')  && (c <= 'z')) ||
			  ((c >= 'A') && (c <= 'Z'))) {
				bufRec->parseState = TVFSOP_NODEDEF;
				bufRec->buf[bufRec->bufi++] = c;
				}
			success = 1;
			break;
		  case TVFSOP_NODEDEF:
			if (((c >= 'a')  && (c <= 'z')) ||
			  ((c >= 'A') && (c <= 'Z')) ||
			  (c == '-') || (c == '_') ||
			  ((c >= '0') && (c <= '9')))
				bufRec->buf[bufRec->bufi++] = c;
			else {
				bufRec->buf[bufRec->bufi] = 0;
				if (bufRec->define) {
					lwprintf(&statDoc, "\nreallocate parse define");
				    DisposePtr(bufRec->define);
				    bufRec->define = 0;
					}
				if (bufRec->define = NewPtrClear(bufRec->bufi + 1)) {  //  error?
					for (bufRec->bufi = 0; bufRec->buf[bufRec->bufi] != 0; bufRec->bufi++)
						bufRec->define[bufRec->bufi] = bufRec->buf[bufRec->bufi];
					lwprintf(&statDoc, "\nDEF %s", bufRec->define);
					}
				bufRec->bufi = 0;
				bufRec->parseState = TVFSOP_NODEPRE;
				}
			success = 1;
			break;
		  case TVFSOP_NODEUSEPRE:
			if (((c >= 'a')  && (c <= 'z')) ||
			  ((c >= 'A') && (c <= 'Z'))) {
				bufRec->parseState = TVFSOP_NODEUSE;
				bufRec->buf[bufRec->bufi++] = c;
				}
			success = 1;
			break;
		  case TVFSOP_NODEUSE:
			if (((c >= 'a')  && (c <= 'z')) ||
			  ((c >= 'A') && (c <= 'Z')) ||
			  (c == '-') || (c == '_') ||
			  ((c >= '0') && (c <= '9')))
				bufRec->buf[bufRec->bufi++] = c;
			else {
				bufRec->buf[bufRec->bufi] = 0;
				/*  call routine to traverse node tree for matching node DEF  */
				if (use(doc->fileBufRec, doc->vrml)) {
					node = bufRec->nodeLinkCurrent->node;
					goto endnodeuse;
					}
				lwprintf(&statDoc, "\nUSE: node DEF %s not found", bufRec->buf);
				goto endnoderesume;
				}
			success = 1;
			break;
		  case TVFSOP_NODEROUTEPR:
			/*  this parse stage should only be reached for ROUTEs embedded in nodes  */
			if ((c == ' ') || (c == '\t') || (c == '\r') || (c == '\n')) {
				bufRec->buf[bufRec->bufi] = 0;
				if (strcmp(bufRec->buf, "ROUTE") == 0)
					bufRec->parseState = TVFSOP_NODEROUTEPRE;
				else
					bufRec->parseState = TVFSOP_FIELDPRE;
				bufRec->bufi = 0;
				}
			else
				bufRec->buf[bufRec->bufi++] = c;  // error?
			success = 1;
			break;
		  case TVFSOP_NODEROUTEPRE:
			if (((c >= 'a')  && (c <= 'z')) ||
			  ((c >= 'A') && (c <= 'Z'))) {
				bufRec->parseState = TVFSOP_NODEROUTESRC;
				bufRec->r.s[0] = &(bufRec->r.c);
				bufRec->r.s[0][bufRec->bufi++] = c;
				}
			success = 1;
			break;
		  case TVFSOP_NODEROUTESRC:
//			if (bufRec->bufi >= FILEBUFREC_PARSEBUFSIZE) {  /*  error ???  */
			if (c == '.') {
				bufRec->r.s[0][bufRec->bufi++] = 0;
				bufRec->r.s[1] = &(bufRec->r.s[0][bufRec->bufi]);
				bufRec->parseState = TVFSOP_NODEROUTESRCFIELD;
				bufRec->bufi = 0;
				}
			else
				bufRec->r.s[0][bufRec->bufi++] = c;
			success = 1;
			break;
		  case TVFSOP_NODEROUTESRCFIELD:
			if ((c == ' ') || (c == '\t') || (c == '\r') || (c == '\n')) {
				bufRec->r.s[1][bufRec->bufi++] = 0;
				bufRec->r.s[2] = &(bufRec->r.s[1][bufRec->bufi]);
				bufRec->bufi = 0;
				bufRec->parseState = TVFSOP_NODEROUTETO;
				}
			else
				bufRec->r.s[1][bufRec->bufi++] = c;
			success = 1;
			break;
		  case TVFSOP_NODEROUTETO:
			if (bufRec->bufi) {
				if ((c == ' ') || (c == '\t') || (c == '\r') || (c == '\n')) {
					bufRec->parseState = TVFSOP_NODEROUTEPRE2;
					bufRec->bufi = 0;
					}
				}
			else if (c == 'T')
				bufRec->bufi++;
			success = 1;
			break;
		  case TVFSOP_NODEROUTEPRE2:
			if (((c >= 'a')  && (c <= 'z')) ||
			  ((c >= 'A') && (c <= 'Z'))) {
				bufRec->parseState = TVFSOP_NODEROUTEDEST;
				bufRec->r.s[2][bufRec->bufi++] = c;
				}
			success = 1;
			break;
		  case TVFSOP_NODEROUTEDEST:
			if (c == '.') {
				bufRec->r.s[2][bufRec->bufi++] = 0;
				bufRec->r.s[3] = &(bufRec->r.s[2][bufRec->bufi]);
				bufRec->bufi = 0;
				bufRec->parseState = TVFSOP_NODEROUTEDESTFIELD;
				}
			else
				bufRec->r.s[2][bufRec->bufi++] = c;
			success = 1;
			break;
		  case TVFSOP_NODEROUTEDESTFIELD:
			if ((c == ' ') || (c == '\t') || (c == '\r') || (c == '\n')) {
				bufRec->r.s[3][bufRec->bufi] = 0;
				lwprintf(&statDoc, "\nskipping ROUTE\n  %s.%s TO\n  %s.%s",
				  bufRec->r.s[0], bufRec->r.s[1], bufRec->r.s[2], bufRec->r.s[3]);
				bufRec->bufi = 0;
//				bufRec->parseState = TVFSOP_NODEPRE;
				goto endnoderesume;
				}
			else
				bufRec->r.s[3][bufRec->bufi++] = c;
			success = 1;
			break;
		  case TVFSOP_NODEIGNORE:
			/*  create a temporary sibling node, parse to its end, then delete it  */
			/*  increment recursion during node ignored parsing only  */
			node = bufRec->nodeLinkCurrent->node;
			if (bufRec->flags & TO_STARTCHAR) {
				bufRec->flags &= ~TO_STARTCHAR;
				node->field += 1;
				}
			if (c == '{')
				node->field += 1;
			else if (c == '}') {
				if (!(bufRec->nodeLinkCurrent->node->field -= 1)) {
					bufRec->nodeLinkCurrent = bufRec->nodeLinkCurrent->prev;
					/*  now delete unsupported node  */
					vrml(&(bufRec->nodeLinkCurrent->next), VNM_DISPOSE, 0);
					goto endnoderesume;
					}
				}
			success = 1;
			break;
		  case TVFSOP_NODEPOST:
			if (c == '{')
				bufRec->parseState = TVFSOP_FIELDPRE;
			/*  else ignore white space  */
			success = 1;
			break;
		  case TVFSOP_FIELDPRE:
			if ((c >= 'a')  && (c <= 'z')) {
				bufRec->buf[bufRec->bufi++] = c;
				bufRec->parseState = TVFSOP_FIELD;
				}
			if (c == 'R') {
				bufRec->buf[bufRec->bufi++] = c;
				bufRec->parseState = TVFSOP_NODEROUTEPR;
				}
			else if (c == '}') {
endnode:		/*  finished parsing this node's fields  */
				node = bufRec->nodeLinkCurrent->node;
				node->field = 0;
				node->flags &= ~VNF_MULTINODE;
				/*  link/'bind' node to root according to flags  */
				if (node->flags & VNF_ISBINDABLE)
					if (!(vrml(&(bufRec->nodeLinkCurrent), VNM_BIND, 0)))
						goto readheaderr;
				/*  build node 3D model using parsed field values  */
				model(node, MODEL_BUILD);  //  error?
endnodeuse:		/*  return to parsing parent node  */
				bufRec->nodeLinkCurrent = bufRec->nodeLinkCurrent->parent;
				if (bufRec->nodeLinkCurrent == NULL) {
					errorMsg = "Open3dView(), unexpected } - no parent!";
					goto readheaderr;
					}
				/*  add node model as child of parent model  */
				if (node->model)
					modelAdd(bufRec->nodeLinkCurrent, node);  //  error?
endnoderesume:	/*  check if current field is multinode  */
				if (bufRec->nodeLinkCurrent->node->flags & VNF_MULTINODE)
//					Check for MULTINODE comma?
					bufRec->parseState = TVFSOP_NODEPRE;
				else
					bufRec->parseState = TVFSOP_FIELDPRE;
				if (statDoc.winPtrx) wprintf(&statDoc, "\n... back to parsing %s",
				  nodeInfo[bufRec->nodeLinkCurrent->node->type].name);
				}
			/*  else ignore white space  */
			success = 1;
			break;
		  case TVFSOP_FIELD:
			if (((c >= 'a')  && (c <= 'z')) || ((c >= 'A')  && (c <= 'Z')) ||
			  ((c >= '0') && (c <= '9')))
				bufRec->buf[bufRec->bufi++] = c;
			else {
				bufRec->buf[bufRec->bufi] = 0;
				bufRec->bufi = 0;
				matchField(bufRec);
				}
			/*  else ignore white space  */
			success = 1;
			break;
		  case TVFSOP_FIELDIGNORE_PRE:
			if ((bufRec->bufi == 0) && (c >= 'A') && (c <= 'Z'))
				bufRec->buf[bufRec->bufi++] = c;
			else if (bufRec->bufi == 1) {
				bufRec->buf[bufRec->bufi++] = c;
				if ((c >= 'a') && (c <= 'z'))
					/*  bit of a hack, but this check seems to detect
					/*  unsupported Nodes in feilds  */
					bufRec->parseState = TVFSOP_FIELDIGNORE_NODE;
				else {
					bufRec->bufi = 0;
					if ((bufRec->buf[0] == 'D') &&
					  (bufRec->buf[1] == 'E'))
						bufRec->parseState = TVFSOP_FIELDIGNORE_DEF;
					else if ((bufRec->buf[0] == 'U') &&
					  (bufRec->buf[1] == 'S'))
						bufRec->parseState = TVFSOP_FIELDIGNORE_USE;
					else
						bufRec->parseState = TVFSOP_FIELDIGNORE_OTHER;
					}
				}
			else if (((c >= '0') && (c <= '9')) || (c == '.') || (c == '-'))
				bufRec->parseState = TVFSOP_FIELDIGNORE_OTHER;
			else if (c == '"')
				bufRec->parseState = TVFSOP_FIELDIGNORE_STRING;
			else if (c == '[')
				bufRec->parseState = TVFSOP_FIELDIGNORE_ARRAY;
			success = 1;
			break;
		  case TVFSOP_FIELDIGNORE_USE:
			if ((c == ' ') || (c == '\t') || (c == '\r') || (c == '\n'))
				bufRec->parseState = TVFSOP_FIELDIGNORE_USEPOST;
			break;
		  case TVFSOP_FIELDIGNORE_USEPOST:
			if (((c >= 'a')  && (c <= 'z')) || ((c >= 'A')  && (c <= 'Z')))
				bufRec->parseState = TVFSOP_FIELDIGNORE_OTHER;
			break;
		  case TVFSOP_FIELDIGNORE_DEF:
			if ((c == ' ') || (c == '\t') || (c == '\r') || (c == '\n'))
				bufRec->parseState = TVFSOP_FIELDIGNORE_DEFINE;
			break;
		  case TVFSOP_FIELDIGNORE_DEFINE:
			if (((c >= 'a')  && (c <= 'z')) || ((c >= 'A')  && (c <= 'Z')))
				bufRec->parseState = TVFSOP_FIELDIGNORE_DEFNODE;
			break;
		  case TVFSOP_FIELDIGNORE_DEFNODE:
			if ((c == ' ') || (c == '\t') || (c == '\r') || (c == '\n'))
				bufRec->parseState = TVFSOP_FIELDIGNORE_DEFPOST;
			break;
		  case TVFSOP_FIELDIGNORE_DEFPOST:
			if ((c >= 'A')  && (c <= 'Z')) {
				bufRec->buf[bufRec->bufi++] = c;
				bufRec->parseState = TVFSOP_FIELDIGNORE_NODE;
				}
			break;
		  case TVFSOP_FIELDIGNORE_OTHER:
			if ((c == ' ') || (c == '\t') || (c == '\r') || (c == '\n'))
				bufRec->parseState = TVFSOP_FIELDPRE;
			success = 1;
			break;
		  case TVFSOP_FIELDIGNORE_STRING:
			if (c == '"')
				bufRec->parseState = TVFSOP_FIELDPRE;
			success = 1;
			break;
		  case TVFSOP_FIELDIGNORE_ARRAY:
			if (c == ']')
				bufRec->parseState = TVFSOP_FIELDPRE;
			success = 1;
			break;
		  case TVFSOP_FIELDIGNORE_NODE:
			if (((c >= 'a')  && (c <= 'z')) ||
			  ((c >= 'A')  && (c <= 'Z')) ||
			  ((c >= '0') && (c <= '9')))
				bufRec->buf[bufRec->bufi++] = c;
			else {
				bufRec->buf[bufRec->bufi] = 0;
				bufRec->bufi = 0;
				bufRec->flags &= ~TO_STARTCHAR;
				if (add(bufRec, VNT_UNSUPPORTED) == NULL) {
add_err:			errorMsg = "Open3dView(), add()";
					goto exit;
					}
				}
			success = 1;
			break;
		  case TVFSOP_MFFLOATPRE:
			if (c == '[') {
				if (bufRec->v.multiArgBufHdl)
					goto mfl_err;
				bufRec->v.multiArgBufHdl = NewHandle(MaxBlock() >> 1);
				if (bufRec->v.multiArgBufHdl == 0) {
mfl_err:			errorMsg = "AllocValueArrayHandle() failed";
					bufRec->parseState = TVFSOP_MFFLOAT_NOMEM;
					}
				else {
					HLock(bufRec->v.multiArgBufHdl);
					bufRec->flags |= TO_VALUEMFFLOAT;
					bufRec->parseState = TVFSOP_MFFLOAT;
					/*  nmax = max number of floats that will fit in buffer  */
					//  error?  16 math will not perform 32 div accurately!
					bufRec->v.multiArgBufnmax = GetHandleSize(bufRec->v.multiArgBufHdl);
					bufRec->v.multiArgBufnmax /= sizeof (VDT_FLOAT);
					bufRec->v.multiArgBufi = 0;
					lwprintf(&statDoc, "\nalloc parse buf: %lx", bufRec->v.multiArgBufnmax);
					}
				}
			break;
		  case TVFSOP_MFFLOAT_NOMEM:
			if (c != ']')
				break;
			/*  fall through  */
		  case TVFSOP_MFFLOAT:
			if (c != ']')
				goto floatpre;
mf:			if (bufRec->v.multiArgBufHdl) {
				tptr = AllocValueArrayPtr(bufRec->v.multiArgBufHdl, bufRec->v.multiArgBufi * sizeof (float));
				if (tptr) {
					/*  dump points to log window  */
					for (i = 0; i < bufRec->v.multiArgBufi; i++) {
						lwprintf(&statDoc, "\n%d", (short) (((float *) tptr)[i] * 100.0));  }
					node = bufRec->nodeLinkCurrent->node;
					((struct VN_IndexedFaceSet *) node)->coordIndex = (VDT_INT32 *) tptr;
//					((struct VN_IndexedFaceSet *) node)->coordIndex = (VDT_FLOAT *) tptr;
					((struct VN_IndexedFaceSet *) node)->ncoordIndexs =  bufRec->v.multiArgBufi;
				    }
			    DisposeHandle(bufRec->v.multiArgBufHdl);
				bufRec->v.multiArgBufHdl = 0;
				lwprintf(&statDoc, "\ndispo parse buf %ld", ((struct VN_IndexedFaceSet *) node)->ncoordIndexs);
				}
			bufRec->flags &= ~TO_VALUEMFFLOAT;
			bufRec->parseState = TVFSOP_FIELDPRE;
			break;
		  case TVFSOP_MFVEC3FPRE:
			if (c == '[') {
				if (bufRec->v.multiArgBufHdl)
					goto mf3_err;
				bufRec->v.multiArgBufHdl = NewHandle(MaxBlock() >> 1);
				if (bufRec->v.multiArgBufHdl == 0) {
mf3_err:			errorMsg = "AllocValueArrayHandle() failed";
					bufRec->parseState = TVFSOP_MFVEC3F_NOMEM;
					}
				else {
					HLock(bufRec->v.multiArgBufHdl);
					bufRec->flags |= TO_VALUEMFVEC3F;
					bufRec->parseState = TVFSOP_MFVEC3F;
					/*  nmax = max number of xyz sets that will fit in buffer  */
					//  error?  16 math will not perform 32 div accurately!
					bufRec->v.multiArgBufnmax = GetHandleSize(bufRec->v.multiArgBufHdl);
					bufRec->v.multiArgBufnmax /= sizeof (VDT_VEC3F);
					bufRec->v.multiArgBufnmax *= sizeof (VDT_FLOAT);
					bufRec->v.multiArgBufi = 0;
					lwprintf(&statDoc, "\nalloc parse buf: %lx", bufRec->v.multiArgBufnmax);
					}
				}
			break;
		  case TVFSOP_MFVEC3F_NOMEM:
			if (c != ']')
				break;
			/*  fall through  */
		  case TVFSOP_MFVEC3F:
			if (c == ']') {
vec3f:			if (bufRec->v.multiArgBufHdl) {
					i = 0;
					tptr = AllocValueArrayPtr(bufRec->v.multiArgBufHdl, bufRec->v.multiArgBufi * sizeof (float));
					if (tptr) {
						node = bufRec->nodeLinkCurrent->node;
						((struct VN_Coordinate *) node)->point = (VDT_VEC3F *) tptr;
						((struct VN_Coordinate *) node)->npoints =  //  error?  16 math may not perform 32 bit divide accurately
						  bufRec->v.multiArgBufi / (sizeof (VDT_VEC3F) / sizeof (VDT_FLOAT));
					    }
				    DisposeHandle(bufRec->v.multiArgBufHdl);
					bufRec->v.multiArgBufHdl = 0;
					lwprintf(&statDoc, "\ndispo parse buf %ld", ((struct VN_Coordinate *) node)->npoints);
					}
				bufRec->flags &= ~TO_VALUEMFVEC3F;
				bufRec->parseState = TVFSOP_FIELDPRE;
				break;
				}
		/*  else, fall through  */
		  case TVFSOP_FLOATPRE:
floatpre:	if (c == '-') {
				bufRec->v.fdec = -1.0;
				bufRec->parseState = TVFSOP_FLOATNEGPRE;
				}
			else if (((c >= '0')  && (c <= '9'))) {
				bufRec->flags &= ~TO_VALUEPOSTDEC;
				bufRec->v.df = (c - '0');
				bufRec->parseState = TVFSOP_FLOAT;
				bufRec->v.fdec = 1.0;
				}
			else if (c == '.') {
				bufRec->flags |= TO_VALUEPOSTDEC;
				bufRec->v.df = 0.0;
				bufRec->parseState = TVFSOP_FLOAT;
				bufRec->v.fdec = 1.0;
				}
			success = 1;
			break;
		  case TVFSOP_FLOATNEGPRE:
			if (((c >= '0')  && (c <= '9'))) {
				bufRec->flags &= ~TO_VALUEPOSTDEC;
				bufRec->v.df = (c - '0');
				bufRec->parseState = TVFSOP_FLOAT;
				}
			else if (c == '.') {
				bufRec->flags |= TO_VALUEPOSTDEC;
				bufRec->v.df = 0.0;
				bufRec->parseState = TVFSOP_FLOAT;
				}
			else {
				errorMsg = "Open3dView(), unrecognized numeric format";
readheaderr:	doc->fileState = TVFS_CLOSE;
				goto exit;
				}
			success = 1;
			break;
		  case TVFSOP_FLOAT:
			if (((c >= '0')  && (c <= '9'))) {
				bufRec->v.df = bufRec->v.df * 10.0;
				bufRec->v.df += (c - '0');
  				if (bufRec->flags & TO_VALUEPOSTDEC) {
					bufRec->v.fdec = bufRec->v.fdec * 10.0;
					}
				}
			else if ((c == '.') && (bufRec->v.fdec != 0.0))
				bufRec->flags |= TO_VALUEPOSTDEC;
			else {
				bufRec->v.df /= bufRec->v.fdec;
				node = bufRec->nodeLinkCurrent->node;
				if (bufRec->flags & TO_VALUEMFVEC3F) {
					if (bufRec->v.multiArgBufi < bufRec->v.multiArgBufnmax) {  //  error?
						((VDT_FLOAT *) *bufRec->v.multiArgBufHdl)[bufRec->v.multiArgBufi] = bufRec->v.df;
						bufRec->v.multiArgBufi++;
						if (c == ']')
						    goto vec3f;
						bufRec->parseState = TVFSOP_MFVEC3F;
						}
					else {
						errorMsg = "Open3dView(), insufficient parse memory";
						bufRec->parseState = TVFSOP_MFVEC3F_NOMEM;
						}
					}
				else if (bufRec->flags & TO_VALUEMFFLOAT) {
					if (bufRec->v.multiArgBufi < bufRec->v.multiArgBufnmax) {  //  error?
						((VDT_FLOAT *) *bufRec->v.multiArgBufHdl)[bufRec->v.multiArgBufi] = bufRec->v.df;
						bufRec->v.multiArgBufi++;
						if (c == ']')
						    goto mf;
						bufRec->parseState = TVFSOP_MFFLOAT;
						}
					else {
						errorMsg = "Open3dView(), insufficient parse memory";
						bufRec->parseState = TVFSOP_MFFLOAT_NOMEM;
						}
					}
				else {
					tptr = (char *) node;
					tptr = tptr + sizeof(struct VN_Nod);
					i = 1;
					while (i < node->field) {
						j = node->type;
						j = nodeInfo[j].fi[i - 1].datatype;
						j = fieldTypeInfo[j].size;
						tptr = tptr + j;
						i++;
						}
					((VDT_FLOAT *) tptr)[bufRec->argi] = bufRec->v.df;
					if (++bufRec->argi < fieldTypeInfo[nodeInfo[node->type].fi[node->field - 1].datatype].elements)
						bufRec->parseState = TVFSOP_FLOATPRE;
					else
						bufRec->parseState = TVFSOP_FIELDPRE;
					}
				}
			success = 1;
			break;
		  case TVFSOP_MFINT32PRE:
			if (c == '[') {
mi:				if (bufRec->v.multiArgBufHdl)
					goto mfi_err;
				bufRec->v.multiArgBufHdl = NewHandle(MaxBlock() >> 1);
				if (bufRec->v.multiArgBufHdl == 0) {
mfi_err:			errorMsg = "AllocValueArrayHandle() failed";
					bufRec->parseState = TVFSOP_MFINT32_NOMEM;
					}
				else {
					HLock(bufRec->v.multiArgBufHdl);
					bufRec->flags |= TO_VALUEMFINT320;
					bufRec->parseState = TVFSOP_MFINT32;
					/*  nmax = max number of int32s that will fit in buffer  */
					//  error?  16 math will not perform 32 div accurately!
					bufRec->v.multiArgBufnmax = GetHandleSize(bufRec->v.multiArgBufHdl);
					bufRec->v.multiArgBufnmax /= sizeof (VDT_INT32);
					bufRec->v.multiArgBufi = 0;
					lwprintf(&statDoc, "\nalloc parse buf: %lx", bufRec->v.multiArgBufnmax);
					}
				}
			break;
		  case TVFSOP_MFINT32_NOMEM:
			if (c != ']')
				break;
			/*  fall through  */
		  case TVFSOP_MFINT32:
			if (c != ']')
				goto int32pre;
			if (bufRec->v.multiArgBufHdl) {
				tptr = AllocValueArrayPtr(bufRec->v.multiArgBufHdl, bufRec->v.multiArgBufi * sizeof (VDT_INT32));
				if (tptr) {
					node = bufRec->nodeLinkCurrent->node;
					((struct VN_IndexedFaceSet *) node)->coordIndex = (VDT_INT32 *) tptr;
					((struct VN_IndexedFaceSet *) node)->ncoordIndexs =  bufRec->v.multiArgBufi;
				    }
			    DisposeHandle(bufRec->v.multiArgBufHdl);
				bufRec->v.multiArgBufHdl = 0;
				lwprintf(&statDoc, "\ndispo parse buf %ld", ((struct VN_IndexedFaceSet *) node)->ncoordIndexs);
				}
			bufRec->flags &= ~TO_VALUEMFINT320;
			bufRec->parseState = TVFSOP_FIELDPRE;
			break;
		  case TVFSOP_INT32PRE:
int32pre:	if (c == '-') {
				bufRec->v.int32 = 0;
				bufRec->flags |= TO_VALUEINTNEG;
				bufRec->parseState = TVFSOP_INT32;
				}
			else if (((c >= '0')  && (c <= '9'))) {
				bufRec->v.int32 = (c - '0');
				bufRec->flags &= ~TO_VALUEINTNEG;
				bufRec->parseState = TVFSOP_INT32;
				}
			success = 1;
			break;
		  case TVFSOP_INT32:
			if (((c >= '0')  && (c <= '9'))) {
				bufRec->v.int32 *= 10;
				if (bufRec->flags & TO_VALUEINTNEG)
					bufRec->v.int32 -= (c - '0');
				else
					bufRec->v.int32 += (c - '0');
				}
			else {
				node = bufRec->nodeLinkCurrent->node;
				if (bufRec->flags & TO_VALUEMFINT320) {
					if (bufRec->v.multiArgBufi < bufRec->v.multiArgBufnmax) {  //  error?
						((VDT_INT32 *) *bufRec->v.multiArgBufHdl)[bufRec->v.multiArgBufi] = bufRec->v.int32;
						bufRec->v.multiArgBufi++;
						if (c == ']')
						    goto mi;
						bufRec->parseState = TVFSOP_MFINT32;
						}
					else {
						errorMsg = "Open3dView(), insufficient parse memory";
						bufRec->parseState = TVFSOP_MFINT32_NOMEM;
						}
					}
				else {
					tptr = (char *) node;
					tptr = tptr + sizeof(struct VN_Nod);
					i = 1;
					while (i < node->field) {
						j = node->type;
						j = nodeInfo[j].fi[i - 1].datatype;
						j = fieldTypeInfo[j].size;
						tptr = tptr + j;
						i++;
						}
					((VDT_INT32 *) tptr)[bufRec->argi] = bufRec->v.int32;
					if (++bufRec->argi < fieldTypeInfo[nodeInfo[node->type].fi[node->field - 1].datatype].elements)
						bufRec->parseState = TVFSOP_INT32PRE;
					else
						bufRec->parseState = TVFSOP_FIELDPRE;
					}
				}
			success = 1;
			break;
		  case TVFSOP_BOOL0:
			if (c == 'T') {
				bufRec->nodeLinkCurrent->node->flags |= VNF_BOL0;
				goto bool;
				}
			else if (c == 'F') {
				bufRec->nodeLinkCurrent->node->flags &= ~VNF_BOL0;
				goto bool;
				}
			break;
		  case TVFSOP_BOOL1:
			if (c == 'T') {
				bufRec->nodeLinkCurrent->node->flags |= VNF_BOL1;
				goto bool;
				}
			else if (c == 'F') {
				bufRec->nodeLinkCurrent->node->flags &= ~VNF_BOL1;
				goto bool;
				}
			break;
		  case TVFSOP_BOOL2:
			if (c == 'T') {
				bufRec->nodeLinkCurrent->node->flags |= VNF_BOL2;
				goto bool;
				}
			else if (c == 'F') {
				bufRec->nodeLinkCurrent->node->flags &= ~VNF_BOL2;
bool:			bufRec->parseState = TVFSOP_FIELDPRE;
				}
			break;
		  case TVFSOP_STRINGPRE:
			if (c == '"') {
				bufRec->parseState = TVFSOP_STRING;
				bufRec->bufi = 0;
				}
			success = 1;
			break;
		  case TVFSOP_STRING:
			if (((c >= 'a')  && (c <= 'z')) || ((c >= 'A')  && (c <= 'Z')) ||
			  ((c >= '0') && (c <= '9')) || (c == '_') || (c == ' '))
				bufRec->buf[bufRec->bufi++] = c;  //  error?? - buffer overrun?
			else {
				bufRec->buf[bufRec->bufi] = 0;
				bufRec->parseState = TVFSOP_FIELDPRE;
				if (bufRec->nodeLinkCurrent->node->type == VNT_VIEWPOINT) {
					if (((struct VN_Viewpoint *) bufRec->nodeLinkCurrent->node)->description =
					  NewPtrClear(bufRec->bufi)) {
						for (bufRec->bufi = 0; bufRec->buf[bufRec->bufi] != 0; bufRec->bufi++)
							((struct VN_Viewpoint *) bufRec->nodeLinkCurrent->node)->description[bufRec->bufi] =
							  bufRec->buf[bufRec->bufi];
						wprintf(&statDoc, "\nViewpoint %s",
						  ((struct VN_Viewpoint *) bufRec->nodeLinkCurrent->node)->description);
						}
					}
				bufRec->bufi = 0;
				}
			success = 1;
			break;
		  default:
			errorMsg = "Open3dView(), unknown parse state";
			doc->fileState = TVFS_CLOSE;
			}
		break;
	  case TVFS_CLOSE:
		if (flags & F_LOG)
			lwprintf(&statDoc, "\nClosing File ...");
		if (doc->fileBufRec) {
			if (doc->fileBufRec->v.multiArgBufHdl){
			    DisposeHandle(doc->fileBufRec->v.multiArgBufHdl);
			    doc->fileBufRec->v.multiArgBufHdl = 0;
				lwprintf(&statDoc, "\ndispo parse buf");
				}
			if (doc->fileBufRec->define){
				lwprintf(&statDoc, "\ndispo parse DEF/ROUTE");
			    DisposePtr(doc->fileBufRec->define);
			    doc->fileBufRec->define = 0;
				}
			}
		doc->flags &= ~(TVF_XFERING | TVF_OPENING);
		doc->fileState = TVFS_VOID;
		fileErr = FSClose(doc->fileRN);
		if (fileErr != noErr) {
			errorMsg = "Open3dView(), FSClose() error";
			goto exit;
			}
		/*  Flush Volume, is this really necessay after reading?  */
		fileErr = FlushVol(0, doc->fileSpec.vRefNum);
		if (fileErr != noErr) {
			errorMsg = "Open3dView(), FlushVol() error";
			goto exit;
			}
		success = 1;
		break;
	  default:
		errorMsg = "Open3dView(), undefined fileState";
		doc->flags &= ~(TVF_OPENING | TVF_NULLON);
		}
exit:
	if (doc->fileState == TVFS_READHEAD) {
		readpass++;
		if (readpass < charsPerPass)
			goto read;
		}
	return (success);
	}


/*  MatchNode()
/*    returns:  0 if fatal error  */
int MatchNode(struct docWindowView *doc) {
	short i;
	short success = 0;
	struct fileBufRec0 *br;

	br = doc->fileBufRec;
	if (br->parseState != TVFSOP_NODE) {
		errorMsg = "MatchNode(), improper parse state";
		goto x;
		}
	if (strcmp(br->buf, "ROUTE") == 0) {
		br->parseState = TVFSOP_NODEROUTEPRE;
		goto usex;
		}
	if (strcmp(br->buf, "DEF") == 0) {
		br->parseState = TVFSOP_NODEDEFPRE;
		goto usex;
		}
	if (strcmp(br->buf, "USE") == 0) {
		br->parseState = TVFSOP_NODEUSEPRE;
usex:	success = 1;
		goto x;
		}
	/*  the following should be able to be turned into a couple of lines
	    of code for all node types  */
    for (i = VNT_VIEWPOINT; i < VNT_TOTAL_DEFINED; i++) {
		if (strcmp(br->buf, nodeInfo[i].name) == 0) {
			if (success = add(br, i)) {
				switch (i) {
				  case VNT_VIEWPOINT:
					/*  make this a vrml method?  */
					((struct VN_Viewpoint *) br->nodeLinkCurrent->node)->root = doc->vrml;
					}
				goto x;
				}
			}
    	}
		success = add(br, VNT_UNSUPPORTED);
x:	return (success);
	}


/*  matchField()
/*    returns:  0 if fatal error  */
int matchField(struct fileBufRec0 *bufRec) {
	struct VN_Nod *current;
	short i, j;
	short success = 0;

	if (bufRec->parseState != TVFSOP_FIELD) {
		errorMsg = "matchFeild(), improper parse state";
		goto x;
		}
	current = bufRec->nodeLinkCurrent->node;
	j = current->type;
	if (!current || (j < 0) || (j >= VNT_TOTAL_DEFINED)) {
		errorMsg = "matchFeild(), undefined node type";
		goto x;
		}
	current->flags &= ~VNF_MULTINODE;
	current->field = 0;
	i = 0;
	while (i < nodeInfo[j].fields) {
		if (nodeInfo[j].fi && nodeInfo[j].fi[i].name) {
			if (strcmp(bufRec->buf, nodeInfo[j].fi[i].name) == 0) {
				current->field = i + 1;
				i = nodeInfo[j].fields;
				}
			}
		i += 1;
		}
	if (current->field)
		switch (nodeInfo[j].fi[current->field - 1].datatype) {
		  case VNDT_MFNODE:
			current->flags |= VNF_MULTINODE;
		  case VNDT_SFNODE:
			bufRec->parseState = TVFSOP_NODEPRE;
			break;
		  case VNDT_SFFLOAT:
		  case VNDT_SFVEC3F:
		  case VNDT_SFROTATION:
			bufRec->parseState = TVFSOP_FLOATPRE;
  			bufRec->argi = 0;
			break;
		  case VNDT_CSTRING:
			bufRec->parseState = TVFSOP_STRINGPRE;
			break;
		  case VNDT_BOOL0:
			bufRec->parseState = TVFSOP_BOOL0;
			break;
		  case VNDT_BOOL1:
			bufRec->parseState = TVFSOP_BOOL1;
			break;
		  case VNDT_BOOL2:
			bufRec->parseState = TVFSOP_BOOL2;
			break;
		  case VNDT_MFVEC3F:
			bufRec->parseState = TVFSOP_MFVEC3FPRE;
			bufRec->v.multiArgBufHdl = 0;
  			bufRec->argi = 0;
			break;
		  case VNDT_MFFLOAT:
			bufRec->parseState = TVFSOP_MFFLOATPRE;
			bufRec->v.multiArgBufHdl = 0;
  			bufRec->argi = 0;
			break;
		  case VNDT_SFINT32:
			bufRec->parseState = TVFSOP_INT32PRE;
  			bufRec->argi = 0;
			break;
		  case VNDT_MFINT32:
			bufRec->parseState = TVFSOP_MFINT32PRE;
			bufRec->v.multiArgBufHdl = 0;
  			bufRec->argi = 0;
			break;
		  default:
			bufRec->parseState = TVFSOP_FIELDIGNORE_PRE;
			}
	else
		bufRec->parseState = TVFSOP_FIELDIGNORE_PRE;
	success = 1;
x:	return (success);
	}


short add(struct fileBufRec0 *bufRec, char type) {
	struct VN_NodeLink *newnode, *current;
	short success = 0;

	/*  this routine will attempt to create a new vrml node,
	/*  add the new node as a child of the current node (including
	/*  making the current node the new node's parent),
	/*  initialize the new nodes model,
	/*  and establish the new node as the current node.
	/*  If the new node is not supported, it is given an
	/*  unsupported type so that it will be bypasses and
	/*  later deleted.  Arguments:
	/*    type: 0  add an unsupported node
	/*          n  supported node type to add
	/*    bufRec->flags.TO_STARTCHAR: tight { after node flag
	/*    bufRec->nodeLinkCurrent: parent of node to add  */
	if (!(vrml(&newnode, VNM_ALLOC, type))) {
		errorMsg = "field() Alloc Failure";
		goto x;
		}
	if (bufRec) {
		if (bufRec->define) {
			lwprintf(&statDoc, "\nadd define: %s", bufRec->define);
			newnode->node->define = bufRec->define;
			bufRec->define = 0;
			}
		}
	/*  handle supported parent node types  */
	if (type) {
		newnode->parent = current = bufRec->nodeLinkCurrent;
		switch (current->node->type) {
		  case VNT_SHAPE:
			if (current->node->field == VNT_SHAPE_APPEARANCE)
				goto add;
			if (current->node->field == VNT_SHAPE_GEOMETRY)
				goto add;
			goto ignore_child;
		  case VNT_TRANSFORM0:
			if (current->node->field == VNT_TRANSFORM_CHILDREN)
				goto add;
			goto ignore_child;
		  case VNT_GROUP:
			if (current->node->field == VNT_GROUP_CHILDREN)
				goto add;
			goto ignore_child;
		  case VNT_INDEXEDFACESET:
			if (current->node->field == VNT_INDEXEDFACESET_COORD)
				goto add;
			goto ignore_child;
		  case VNT_ROOT:
			if (current->node->field == VNT_ROOT_CHILDREN) {
add:			vrml(&newnode, VNM_CHILDADD, 0);
				if (bufRec->flags & TO_STARTCHAR) {
//					bufRec->flags &= ~TO_STARTCHAR;
					bufRec->parseState = TVFSOP_FIELDPRE;
					}
				else
					bufRec->parseState = TVFSOP_NODEPOST;
				}
			else {
ignore_child:	lwprintf(&statDoc, "\n%s: ignoring unexpected child %s",
				  nodeInfo[current->node->type].name, bufRec->buf);
				goto ignore;
				}
			break;
		  default:
			errorMsg = "add(): undefined parent node type";
			goto x;  /*  error?? delete just created VRML node prior to exiting?  */
			}
		/*  prior to parsing node, create group model if needed  */
		model(newnode->node, MODEL_INIT);  //  error?
		success = 1;
		}
	/*  unsupported node type, create dummy sibling node and ignore  */
	else {
  		if ((flags & F_LOG) && statDoc.winPtrx)
			wprintf(&statDoc, "\nignoring node %s", bufRec->buf);
ignore:	newnode->prev = bufRec->nodeLinkCurrent;
		newnode->next = bufRec->nodeLinkCurrent->next;
		bufRec->nodeLinkCurrent->next = newnode;
		newnode->parent = bufRec->nodeLinkCurrent->parent;
		bufRec->parseState = TVFSOP_NODEIGNORE;
		success = 1;
		}
	bufRec->nodeLinkCurrent = newnode;
x:	return (success);
	}


short use(struct fileBufRec0 *bufRec, struct VN_NodeLink *rootLink) {
	struct VN_NodeLink *newLink;
	struct VN_Nod *matchNode;
	short success = 0;

	/*  This routine attempts to find an existing node within the node tree
	/*  pointed to by rootLink that has a DEF matching bufRec->buf .
	/*  If match found, allocate a new nodelink to it and add it as a child
	/*  to the current node.  If child add successful, make new nodelink the
	/*  currentlink and increment the use count on the matched node  */
	if (rootLink == 0)
		goto x;
	if ((bufRec == 0) || (bufRec->nodeLinkCurrent == 0))
		goto x;
	matchNode = traverseLink(rootLink, bufRec->buf);
	if (matchNode == 0) {
		lwprintf(&statDoc, "\nUSE %s UNDEFINED!", bufRec->buf);
		goto x;
		}
	lwprintf(&statDoc, "\nUSE %s found", bufRec->buf);
	/*  consider pushing the following code down into vrml(..., VNM_CHILDADD, 2) ???   */
	newLink = (struct VN_NodeLink *) NewPtrClear(sizeof (struct VN_NodeLink));
	if (newLink == 0)
		goto x;
	newLink->parent = bufRec->nodeLinkCurrent;
	newLink->node = matchNode;
	if (vrml(&newLink, VNM_CHILDADD, 0)) {
		bufRec->nodeLinkCurrent = newLink;
		matchNode->use += 1;
		success = 1;
		}
	else
		DisposePtr((char *) newLink);
x:	bufRec->bufi = 0;
	return (success);
    }


struct VN_Nod *traverseLink(struct VN_NodeLink *nodeLink, char *use) {
	struct VN_Nod *node;
	struct VN_Nod *matchNode = 0;
	struct VN_Nod **root;
	struct VN_NodeLink *child;
	char *s;
	short i, j;

	/*  This is a recursive routine  */
	while (nodeLink) {
		if (nodeLink->node) {
		/*  check if of known node type here ??????  */
			node = nodeLink->node;
			s = (node->define) ? node->define : "";
//			if ((flags & F_LOG) && statDoc.winPtrx)
//			    wprintf(&statDoc, "\n%s: %s=%s?", nodeInfo[node->type].name, use, s);
			if (strcmp(s, use) == 0) {
				matchNode = node;
				goto x;
				}
			/*  decend into node children  */
			root = &((VN_Nod *) (((struct VN_Root *) node)->children));
			i = 0;
			while (i < nodeInfo[node->type].fields) {
				/*  only traverse fields that may have children  */
				j = nodeInfo[node->type].fi[i].datatype;
				if ((j == VNDT_RESERVEDPTR) || (j > VNDT_MFNODE))
					break;
				if (child = (struct VN_NodeLink *) root[i]) {
//					doWindowStat(TSW_REPORTMEM);
					/*  check stack space before calling?  */
					if (matchNode = traverseLink(child, use))
						goto x;
					}
				i++;
				}
			}
		nodeLink = nodeLink->next;
		}
x:	return (matchNode);
	}  /*  */


char *AllocValueArrayPtr(Handle Hdl, long size) {
	char *newptr = 0;
	char *oldptr;

	/*  Take the values parsed into memory pointed to by the locked handle
	/*  and copy them to a non relocatable block of specified size.  Return
	/*  pointer of non relocatable block containing copy of parsed values  */
	if (size == 0)
		goto x;
	HUnlock(Hdl);
	newptr = NewPtr(size);
	if (newptr == 0) {
		errorMsg = "AllocValueArray() failed";
		goto x;
		}
	HLock(Hdl);
	oldptr = *Hdl;
	BlockMove(oldptr, newptr, size);
x:	return (newptr);
	}
