/*	zap technologies - copyright 1999  */
/*	http://www.zaptech.com             */
/*
/*  This code handles all 3D window events processing.
/*
/*  1999-03-21 - overhauled for Universal Headers 3.X
/*  1999-02-05 - overhauled for VN_NodeLink use
/*
/*  Note:
/*  - most routines return 0 if an error occurs
/*  - many routines will set global string pointer errorMsg
/*    if they encounter an error
*/

/*  headers  */
#include <Windows.h>
#include <Timer.h>
#include <Controls.h>
#include <StandardFile.h>
#include <ToolUtils.h>
#include <QD3D.h>
#include <QD3DMath.h>

extern struct UnsignedWide microTicks;
#include "myio.h"
#include "vrml.h"
#define H_TWIRL
#define H_TWIRL_TV
#include "twirl.h"
#undef H_TWIRL
#undef H_TWIRL_TV
#define H_MODEL/*
#define H_MODEL_M*/
#include "models.h"/*
#undef H_MODEL_M*/
#undef H_MODEL
#define H_PARSE_PROTOS
#include "parse.h"
#undef H_PARSE_PROTOS

#define WINDEFAULTW 224
#define WINDEFAULTH 256
#define CTLPANELH    28
#define BW0          30  /*  button widths  */
#define BW           60
#define BW2         120
#define BH           20  /*  button height  */
#define BH2          40  /*  button height  */


/*  local prototypes  */
int ViewReset(struct VN_NodeLink *vnodelink, struct twirlRec *twirl);
void viewPrev(struct VN_NodeLink *rnodelink);
void viewNext(struct VN_NodeLink *rnodelink);
char *viewName(struct VN_NodeLink *rnodelink);


enum {  /*  ViewReset() return codes  */
	VR_NOCHANGE = 1,
	VR_CHANGED =  2
	};


int ViewReset(struct VN_NodeLink *rnodelink, struct twirlRec *twirl) {
	struct VN_Root *rnode;
	struct VN_Viewpoint *vnode;
	int success = 0;

	/*  return codes:
	/*    VR_NOCHANGE, viewpoint remains unchanged
	/*    VR_CHANGED,  viewpoint changed  */
	if (!rnodelink)
		goto error;
	rnode = (struct VN_Root *) rnodelink->node;
	if (!rnode)
		goto error;
	if ((rnode->node.flags & VNF_FLDCHG) == 0) {
		success = VR_NOCHANGE;
		goto x;
		}
	rnode->node.flags &= ~VNF_FLDCHG;
	if (! (((struct VN_Root *) rnode)->views) )
		goto error;
	vnode = (struct VN_Viewpoint *) ((struct VN_Root *) rnode)->views->node;
	if (!vnode) {
error:	errorMsg = "viewReset() Error: invalid reference";
		goto x;
		}
	twirl->px = vnode->position.x;
	twirl->py = vnode->position.y;
	twirl->pz = vnode->position.z;
	twirl->ox = vnode->orientation.x;
	twirl->oy = vnode->orientation.y;
	twirl->oz = vnode->orientation.z;
	twirl->or = vnode->orientation.r;
	/*  lwprintf() changes current graphics port!  */
	lwprintf(&statDoc, "\nview: %s", vnode->description);
	success = VR_CHANGED;
x:	return (success);
	}


void viewNext(struct VN_NodeLink *rnodelink) {
	struct VN_Root *rnode;

	rnode = (struct VN_Root *) rnodelink->node;
	if (rnode->views) {
		rnode->views =
		  ((struct VN_Viewpoint *) rnode->views->node)->nextview;
		rnode->node.flags |= VNF_FLDCHG;  /*  Root field has changed  */
		}
	}


void viewPrev(struct VN_NodeLink *rnodelink) {
	struct VN_Root *rnode;

	rnode = (struct VN_Root *) rnodelink->node;
	if (rnode->views) {
		rnode->views =
		  ((struct VN_Viewpoint *) rnode->views->node)->prevview;
		rnode->node.flags |= VNF_FLDCHG;  /*  Root field has changed  */
		}
	}


char *viewName(struct VN_NodeLink *rnodelink) {
	struct VN_Root *rnode;
	struct VN_Viewpoint *vnode;

	if (rnode = (struct VN_Root *) rnodelink->node) {
		if (rnode->views == 0)
			goto bonk;
		if ((vnode = (struct VN_Viewpoint *) rnode->views->node) == 0)
			goto bonk;
		return (vnode->description);
		}
	else
bonk:	return (0);
	}


/*  doWindowView()
/*  This function is only called from routines in twirl.c .  */
doWindowView(int method, char id) {
	static char about2Text[] = "zap technologies 1998" "http://www.zaptech.com" VERSIONSTR;
	static char errorMsgAlloc[] = "3D View Document Allocation Failed";
	/*  min height, min width, max height, max width  */
	static Rect windowLimits = { WINDEFAULTW, WINDEFAULTH, 32000, 32000};
	static struct docWindowView *docs[MAX3DVIEWS] = { 0 };
	static char title[32] = "\ptwirl x";
	static StandardFileReply sfReply;
	struct docWindowView *docptr;
	char *cptr;
	Rect ButtonBounds;
	ControlHandle control;
	short controlPart;
	GDHandle gfxDevHdl0;
	TQ3Matrix4x4 tmp;
	long growSize;
	short i;
	short success = 0;
	
	switch (method) {
	  case TW_UPDATE:
		docptr = docs[id];
		if (docptr->twirl.view)
			Twirl(docptr, TWIRL_DRAW);  //  error?
		if (docptr->twirl.flags & TF_SHOWCTRLS) {
			if (docptr->twirl.flags & TF_VPCTRLS) {
				SetPort(docptr->winPtr);
				TextSize(12);
				if (docptr->vrml) {
					if (cptr = viewName(docptr->vrml)) {
						MoveTo(BW + 12, 12 + (docptr->twirl.pane0.bottom + CTLPANELH - BH - 4) + 3);
						DrawText(cptr, 0, 6);
//						if (flags & F_LOG)
//							if (statDoc.winPtrx) wprintf(&statDoc, "\nviewpoint: %s", cptr);
						}
					}
				else {
					MoveTo((docptr->twirl.pane0.right - TextWidth(about2Text, 0, 22)) >> 1, 12 + (docptr->twirl.pane0.bottom + CTLPANELH - BH - 4) + 3);
					DrawText(about2Text, 0, 22);
					}
				}
			UpdateControls(docptr->winPtr, docptr->winPtr->visRgn);
			}
		break;
	  case TW_NULL:
		docptr = docs[id];
		if (docptr) {
			/*  with this implementation view does not animate while loading  */
			if ((docptr->flags & (TVF_NULLON | TVF_OPENING)) == TVF_NULLON) {
//				if (!(docptr->winPtr)) {
//					errorMsg = "doWindowView() Error: no View Window";
//					goto exit;
//					}
				Microseconds(&microTicks);  /*  get microseconds since boot  */
				if (docptr->flags & TVF_AUTOSPIN) {
					Q3Matrix4x4_SetRotate_XYZ(&tmp, docptr->twirl.rx, docptr->twirl.ry, docptr->twirl.rz);
					Q3Matrix4x4_Multiply(&docptr->twirl.rotation, &tmp, &docptr->twirl.rotation);
					}
				/*  invalidate 3d pane  */
				SetPort((GrafPtr) docptr->winPtr);
				InvalRect(&docptr->twirl.pane0);
				/*  check if viewpoint changed  */
				if (docptr->vrml) {
					i = ViewReset(docptr->vrml, &docptr->twirl);
					if (i == 0)
						goto exit;
					if (i == VR_CHANGED) {
						/*  ViewReset()'s lwprintf() changes current graphics port!  */
						SetPort((GrafPtr) docptr->winPtr);
						goto nullvprefresh;
						}
					}
				else {
					/*  refresh viewpoint controls  */
nullvprefresh:		if (docptr->twirl.flags & TF_SHOWCTRLS) {
						i = docptr->twirl.pane0.top;
						docptr->twirl.pane0.top = docptr->twirl.pane0.bottom + 1;
						docptr->twirl.pane0.bottom += CTLPANELH;
						EraseRect(&docptr->twirl.pane0);
						InvalRect(&docptr->twirl.pane0);
						docptr->twirl.pane0.bottom -= CTLPANELH;
						docptr->twirl.pane0.top = i;
						}
					moveCamera(&docptr->twirl, TVC_SET);  /*  may call SetPort() for a different winodw  */
					}
				}
			else if (docptr->flags & TVF_OPENING)
				if (!(Open3dView(docptr)))
					goto exit;
			}
		success = 1;
		break;
	  case TW_CONTENT:
		docptr = docs[id];
		SetPort(docptr->winPtr);
		GlobalToLocal(&docptr->event.where);
		controlPart = FindControl(docptr->event.where, docptr->winPtr, &control);
		if (control == 0) {
			lwprintf(&statDoc, "\nview no ctrl: %d,%d", docptr->event.where.h, docptr->event.where.v);
			}
		else if (control == docptr->twirl.viewPrevButtonHdl) {
			/*  TrackControl != 0 only if button released inside control  */
			if (TrackControl(control, docptr->event.where, 0)) {
				lwprintf(&statDoc, "\nview prev: %d,%d",
				  docptr->event.where.h, docptr->event.where.v);
				if (docptr->vrml)
					viewPrev(docptr->vrml);
				}
			}
		else if (control == docptr->twirl.viewNextButtonHdl) {
			if (TrackControl(control, docptr->event.where, 0)) {
				lwprintf(&statDoc, "\nview next: %d,%d",
				  docptr->event.where.h, docptr->event.where.v);
				if (docptr->vrml)
					viewNext(docptr->vrml);
				}
			}
		success = 1;
		break;
	  case TW_TOGGLECTRLS:
		docptr = docs[id];
toggle:	docptr->twirl.pane0 = ((GrafPtr) docptr->winPtr)->portRect;
		/*  top, left, right & bottom have just been set to window edge  */
		if (docptr->twirl.flags & TF_SHOWCTRLS) {
			docptr->twirl.flags &= ~TF_SHOWCTRLS;
			if (docptr->twirl.flags & TF_VPCTRLS) {
				doWindowStat(TSW_REPORTMEM);
				if (docptr->vrml) {
					HideControl(docptr->twirl.viewPrevButtonHdl);
					HideControl(docptr->twirl.viewNextButtonHdl);
					}
				}
			}
		else {
			docptr->twirl.flags |= TF_SHOWCTRLS;
redrawctrls:/*  clear controls rect  */
			i = docptr->twirl.pane0.top;
			docptr->twirl.pane0.top = docptr->twirl.pane0.bottom - CTLPANELH;
			SetPort((GrafPtr) docptr->winPtr);
			EraseRect(&docptr->twirl.pane0);
			docptr->twirl.pane0.top = i;
			/*  invalidate (force update event) of entire window  */
			InvalRect(&docptr->twirl.pane0);
			docptr->twirl.pane0.bottom -= CTLPANELH;
			if (docptr->twirl.flags & (TF_VPCTRLS | TF_SHOWCTRLS)) {
				doWindowStat(TSW_REPORTMEM);
				if (docptr->vrml) {
					ShowControl(docptr->twirl.viewPrevButtonHdl);
					ShowControl(docptr->twirl.viewNextButtonHdl);
					}
				}
			}
		moveCamera(&docptr->twirl, TVC_PANE);
		break;
	  case TW_INIT:  /*  non-VRML  */
		/*  check for free doc ptr  */
		i = 0;
		while (docs[i])
			if  (++i >= MAX3DVIEWS)
				goto errallocinit;
		/*  allocate 3D View document structure  */
		docptr = docs[i] = (struct docWindowView *) NewPtrClear(sizeof (struct docWindowView));
		if (!docptr) {
errallocinit:	errorMsg = errorMsgAlloc;
				goto exit;
				}
	  	/*  create 3d view window  */
		docptr->id = i;
		docptr->type = TV3D;
		docptr->fileState = TVFS_VOID;
		docptr->fileBufRec = 0;
		docptr->vrml = 0;
		gfxDevHdl0 = GetMainDevice();
		docptr->twirl.pane0.top =  randomLimit((*gfxDevHdl0)->gdRect.bottom - 224 - 48) + 42;
		docptr->twirl.pane0.left = randomLimit((*gfxDevHdl0)->gdRect.right  - 256 - 12) + 6;
		docptr->twirl.pane0.bottom = 224 + docptr->twirl.pane0.top;
		docptr->twirl.pane0.right =  256 + docptr->twirl.pane0.left;
	  	title[7] = '1' + docptr->id;
		docptr->winPtr = NewCWindow(nil, &(docptr->twirl.pane0),
		  (const unsigned char *) title, true,
		  documentProc, (WindowPtr) - 1, true, (long) docptr);
		if (!docptr->winPtr) {
			errorMsg = "3D Window Initialization Failed";
			goto exitptr;
			}
		docptr->twirl.pane0.bottom -= docptr->twirl.pane0.top;
		docptr->twirl.pane0.right -=  docptr->twirl.pane0.left;
		docptr->twirl.pane0.top =  0;
		docptr->twirl.pane0.left = 0;
		docptr->twirl.flags = TF_VPCTRLS;
		docptr->twirl.model = 0;
		docptr->twirl.shader = 0;
		docptr->twirl.interpolation = 0;
		docptr->twirl.backFacing = 0;
		docptr->twirl.fillStyle = 0;
		if (!(Init3dView(docptr))) {
			errorMsg = "3D View Initialization Failed";
			DisposeWindow(docptr->winPtr);
exitptr:	DisposePtr((char *) docptr);  docptr = 0;
			goto exit;
			}
		docptr->twirl.rx = (Random() >> 12) + (Random() & 1);  docptr->twirl.rx /= 256.0;
		docptr->twirl.ry = (Random() >> 12) + (Random() & 1);  docptr->twirl.ry /= 256.0;
		docptr->twirl.rz = (Random() >> 12) + (Random() & 1);  docptr->twirl.rz /= 256.0;
		docptr->twirl.ox = 0.0;
		docptr->twirl.oy = 0.0;
		docptr->twirl.oz = 1.0;
		docptr->twirl.or = 0.0;
		docptr->twirl.pz = 4.0;
		moveCamera(&docptr->twirl, TVC_SET);
		docptr->navigationMode = TVNM_STUDY;
		if (flags & F_LOG)
			if (statDoc.winPtrx) wprintf(&statDoc, "\n3D View Window %d OK %x", docptr->id, docptr->flags);
		docptr->flags |= (TVF_NULLON | TVF_AUTOSPIN);    /* enable background window updating  */
		if (++qtyOpen3D >= MAX3DVIEWS)
			DisableItem(mh1, TMF_NEW);
		EnableItem(mh1, TMF_SAVEAS);
		DisableItem(mh1, TMF_SAVE);
		EnableItem(mh1, TMF_CLOSE);
		InsertMenu(mh2, 0);
		success = 1;
		break;
	  case TW_OPEN:  /*  VRML  */
	  	/*  File Requester  */
		StandardGetFile(NULL, -1, NULL, &sfReply);  //  error?
		if (!sfReply.sfGood) {
			errorMsg = "StandardGetFile() canceled";
			goto exit;
			}
		/*  check for free doc ptr  */
		/*  FUTURE - replace contents of selected window?  */
		i = 0;
		while (docs[i])
			if (++i >= MAX3DVIEWS)
				goto errallocopen;
		/*  allocate pre-zeroed 3D View document structure  */
		docptr = docs[i] = (struct docWindowView *) NewPtrClear(sizeof (struct docWindowView));
		if (!docptr) {
errallocopen:	errorMsg = errorMsgAlloc;
				goto exit;
				}
		/*  allocate file buffer record  */
		docptr->fileBufRec = (struct fileBufRec0 *) NewPtrClear(sizeof (struct fileBufRec0));
		if (!(docptr->fileBufRec)) {
			errorMsg = "fileBufRec Alloc Failure";
			goto exitptro;
			}
		docptr->id = i;
		docptr->type = TV3D;
		docptr->flags = TVF_XFERING;
		docptr->fileState = TVFS_VOID;
		docptr->fileSpec = sfReply.sfFile;
		/*  allocate vrml root node  */
		if (!(vrml(&(docptr->vrml), VNM_ALLOC, VNT_ROOT)))
			goto exitfilerec;
		docptr->fileBufRec->nodeLinkCurrent = docptr->vrml;
		/*  create a window to display file  */
		gfxDevHdl0 = GetMainDevice();
		docptr->twirl.pane0.top =  randomLimit((*gfxDevHdl0)->gdRect.bottom - 224 - 48) + 42;
		docptr->twirl.pane0.left = randomLimit((*gfxDevHdl0)->gdRect.right  - 256 - 12) + 6;
		docptr->twirl.pane0.bottom = 224 + docptr->twirl.pane0.top;
		docptr->twirl.pane0.right =  256 + docptr->twirl.pane0.left;
	  	title[7] = '1' + docptr->id;
		docptr->winPtr = NewCWindow(nil, &(docptr->twirl.pane0), (const unsigned char *) title,
		  true, documentProc, (WindowPtr) - 1, true, (long) docptr);
		if (!docptr->winPtr) {
			errorMsg = "3D Window Initialization Failed";
			goto exitvrml;
			}
		/*  set initial rectangle for 3D rendering  */
		docptr->twirl.pane0.bottom -= docptr->twirl.pane0.top;
		docptr->twirl.pane0.right -=  docptr->twirl.pane0.left;
		docptr->twirl.pane0.top =  0;
		docptr->twirl.pane0.left = 0;
		/*  create window controls, then hide if not enabled  */
		docptr->twirl.flags = TF_SHOWCTRLS | TF_VPCTRLS;
		if (docptr->twirl.flags & TF_VPCTRLS) {
		  	ButtonBounds.bottom = docptr->twirl.pane0.bottom - 4;
			ButtonBounds.top = ButtonBounds.bottom - BH;
			ButtonBounds.left = 4;
			ButtonBounds.right = ButtonBounds.left + BW0;
			if (!(docptr->twirl.viewPrevButtonHdl = NewControl(docptr->winPtr, &ButtonBounds, "\p<",
			  true, 0, 0, 1, pushButProc, 0)))
				goto errctls;
			ButtonBounds.left += BW0 + 4;
			ButtonBounds.right += BW0 + 4;
			if (!(docptr->twirl.viewNextButtonHdl = NewControl(docptr->winPtr, &ButtonBounds, "\p>",
			  true, 0, 0, 1, pushButProc, 0))) {
				DisposeControl(docptr->twirl.viewPrevButtonHdl);
errctls:		errorMsg = "3D Window Initialization Failed";
				goto exitctls;
				}
			}
		if (docptr->twirl.flags & TF_SHOWCTRLS)
			docptr->twirl.pane0.bottom -= CTLPANELH;
		else if (docptr->twirl.flags & TF_VPCTRLS) {
			HideControl(docptr->twirl.viewPrevButtonHdl);
			HideControl(docptr->twirl.viewNextButtonHdl);
			}
		/*  prepare 3D context  */
		docptr->twirl.view = 0;  //  aren't these already zero?
		docptr->twirl.shader = 0;
		docptr->twirl.model = 0;
		docptr->twirl.interpolation = 0;
		docptr->twirl.backFacing = 0;
		docptr->twirl.fillStyle = 0;
		if (!(Twirl(docptr, TWIRL_VIEWNEW))) {  /*  this sets a default camera angle  */
			DisposeControl(docptr->twirl.viewPrevButtonHdl);
			DisposeControl(docptr->twirl.viewNextButtonHdl);
exitctls:	DisposeWindow(docptr->winPtr);
exitvrml:	vrml(&(docptr->vrml), VNM_DISPOSE, 0);
exitfilerec:DisposePtr((char *) docptr->fileBufRec);
exitptro:	DisposePtr((char *) docptr);
			docptr = 0;
			goto exit;
			}
		docptr->twirl.rx = (Random() >> 12) + (Random() & 1);  docptr->twirl.rx /= 256.0;
		docptr->twirl.ry = (Random() >> 12) + (Random() & 1);  docptr->twirl.ry /= 256.0;
		docptr->twirl.rz = (Random() >> 12) + (Random() & 1);  docptr->twirl.rz /= 256.0;
		docptr->navigationMode = TVNM_STUDY;
		docptr->flags = TVF_NULLON | TVF_OPENING | TVF_REFLINES | TVF_AUTOSPIN | TVF_XFERING;
		docptr->fileState = TVFS_OPENREAD;  /*  this will make TW_NULL call Open3dView()  */
		if (++qtyOpen3D >= MAX3DVIEWS)
			DisableItem(mh1, TMF_NEW);  // error? = this TV3D may not be front window
		DisableItem(mh1, TMF_SAVEAS);
		DisableItem(mh1, TMF_SAVE);
		DisableItem(mh1, TMF_CLOSE);
		InsertMenu(mh2, 0);
		success = 1;
		break;
	  case TW_GROW:
		docptr = docs[id];
		growSize = GrowWindow(docptr->winPtr, docptr->event.where, &windowLimits);
		if (flags & F_LOG)
			if (statDoc.winPtrx) wprintf(&statDoc, "\nGrow Window %d,%d", LoWord(growSize), HiWord(growSize));
		if (growSize) {
			SizeWindow(docptr->winPtr, LoWord(growSize), HiWord(growSize), 1);
			/*  right & bottom have just been set to window edge  */
			docptr->twirl.pane0.right =  LoWord(growSize);
			docptr->twirl.pane0.bottom = HiWord(growSize);
			if ((docptr->twirl.flags & TF_VPCTRLS) && docptr->vrml) {
				MoveControl(docptr->twirl.viewPrevButtonHdl, 4, docptr->twirl.pane0.bottom - 4 - BH);
				MoveControl(docptr->twirl.viewNextButtonHdl, 4 + BW0 + 4, docptr->twirl.pane0.bottom - 4 - BH);
				}
			if (docptr->twirl.flags & TF_SHOWCTRLS)
				goto redrawctrls;
			}
		break;
	  case TW_KEYBOARD:
		docptr = docs[id];
		if (docptr->event.modifiers & cmdKey) {
			switch (docptr->event.message & 0xFF) {
			  case 't':
				goto toggle;
			  case 'h':
				doWindowStat(TSW_REPORTMEM);
				}
			}
		else if (docptr->event.modifiers & optionKey) {
			switch (docptr->event.message & 0xFF) {
			  case 30:  /*  cursor up  */
				if (flags & F_LOG) if (statDoc.winPtrx) wprintf(&statDoc, "\nviewpoint prev");
				break;
			  case 31:  /*  cursor down  */
				if (flags & F_LOG) if (statDoc.winPtrx) wprintf(&statDoc, "\nviewpoint next");
				}
			}
		else {
			switch (docptr->event.message & 0xFF) {
			  case 'c':
				moveCamera(&docptr->twirl, TVC_LOG);
				break;
			  case 'r':
				if (docptr->navigationMode != TVNM_ROTATE)
					docptr->navigationMode = TVNM_ROTATE;
				else
					docptr->flags ^= TVF_AUTOSPIN;
				break;
			  case 's':
				if (docptr->navigationMode != TVNM_STUDY)
					docptr->navigationMode = TVNM_STUDY;
				break;
			  case 30:  /*  cursor up  */
				switch (docptr->navigationMode) {
				  case TVNM_ROTATE:
					docptr->twirl.rx -= 1.0 / 256.0;
					break;
				  default:
					moveCamera(&docptr->twirl, TVC_APPROACH);
					}
				break;
			  case 31:  /*  cursor down  */
				switch (docptr->navigationMode) {
				  case TVNM_ROTATE:
					docptr->twirl.rx += 1.0 / 256.0;
					break;
				  default:
					moveCamera(&docptr->twirl, TVC_PULLBACK);
					}
				break;
			  case 28:  /*  cursor left  */
				docptr->twirl.ry -= 1.0 / 256.0;
				break;
			  case 29:  /*  cursor right  */
				docptr->twirl.ry += 1.0 / 256.0;
				break;
			  case 44:  /*  commma  */
				docptr->twirl.rz += 1.0 / 256.0;
				break;
			  case 46:  /*  period  */
				docptr->twirl.rz -= 1.0 / 256.0;
				break;
				}
			}
		break;
	  case TW_SAVE:
		docptr = docs[id];
		if (Save3dView(docptr)) {
			DisableItem(mh1, TMF_SAVE);
			docptr->flags &= ~TVF_DIRTY;
			success = 1;
			}
		break;
	  case TW_SAVEAS:
		success = 1;
		break;
	  case TW_CLOSE:
		docptr = docs[id];
		DeleteMenu(130);
		if (docptr) {
			if ((flags & F_LOG) && statDoc.winPtrx)
				wprintf(&statDoc, "\nClosing 3D View %d", docptr->id);
			if (docptr->fileState) {
				docptr->fileState = TVFS_CLOSE;	/*  set state to closing  */
				Open3dView(docptr);				/*  perform close  */
				}
			/*  deallocate vrml scene graph  */
			if (docptr->vrml)
				vrml(&(docptr->vrml), VNM_DISPOSE, 0);
			/*  deallocate any active twirl fields  */
			Twirl(docptr, TWIRL_DISPOSE);
			if (docptr->winPtr)        DisposeWindow(docptr->winPtr);
			if (docptr->fileBufRec) {
				if (docptr->fileBufRec->v.multiArgBufHdl){
				    DisposeHandle(docptr->fileBufRec->v.multiArgBufHdl);
					lwprintf(&statDoc, "\ndispo parse buf");
					}
			    DisposePtr((char *) docptr->fileBufRec);
			    }
			DisposePtr((char *) docs[id]);  docs[id] = 0;
			EnableItem(mh1, TMF_NEW);
			doWindowStat(TSW_REPORTMEM);
			}
		break;
	  default:
		errorMsg = "undefined 3D View method";
		}
exit:
	return (success);
	}
