/*	zap technologies, copyright 1999
/*  http://www.zaptech.com
/*
/*  1999-10-31 - added support for Group node
/*  1999-02-01 - added VN_NodeLink definitions and changed Node.field
/*                     Node.use
/*  1997-10-19  - created
*/


/*  vrml datatypes defined with standard C datatypes  */
/*  (standard C datatypes are stored differently on different systems)  */
typedef struct VN_NodeLink *VDT_NODELINKPTR;
typedef long VDT_INT32;
typedef float VDT_FLOAT;
typedef struct VDT_VEC3F {
	VDT_FLOAT x;
	VDT_FLOAT y;
	VDT_FLOAT z;
	} VDT_VEC3F;
typedef struct VDT_ROTATION {
	VDT_FLOAT x;
	VDT_FLOAT y;
	VDT_FLOAT z;
	VDT_FLOAT r;
	} VDT_ROTATION;


/*  vrml node field datatypes  */
enum {
	VNDT_RESERVEDPTR = 0,
	VNDT_SFNODE,
	VNDT_MFNODE,
	VNDT_CSTRING,
	VNDT_SFFLOAT,
	VNDT_MFFLOAT,
	VNDT_SFVEC3F,
	VNDT_MFVEC3F,
	VNDT_SFROTATION,
	VNDT_SFINT32,
	VNDT_MFINT32,
	VNDT_TOTAL_DEFINED,
	VNDT_BOOL0,  /*  booleans stored with node flags  */
	VNDT_BOOL1,
	VNDT_BOOL2
	};

/*  vrml node types  */
enum {
	VNT_UNSUPPORTED = 0,
	VNT_ROOT,
	VNT_VIEWPOINT,
	VNT_TRANSFORM0,
	VNT_GROUP,
	VNT_SHAPE,
	VNT_APPEARANCE,
	VNT_BOX,
	VNT_CYLINDER,
	VNT_INDEXEDFACESET,
	VNT_COORDINATE,
	VNT_TOTAL_DEFINED
	};

/*  misc vrml methods  */
enum {
	VNM_ALLOC = 1,
	VNM_CHILDADD,
	VNM_BIND,
	VNM_UNBIND,
	VNM_DISPOSE
	};


/*  Note, all child bearing fields must be clustered in node structures
    to immediately follow the VN_Node header common to all VRML node structures.
    This allows node heirarchy searches and recursive disposals to descend
    into children nodes without undue node semantic specific code.  */

/*  Used for building an array containing node information that
    can be referenced easily by node heirarchy manipulation routines.  */
struct VN_FIELDDATATYPEINFO{
	short size;
	short elements;
	};

struct VN_FIELDINFO{
	short datatype;
	char *name;
	};

struct VN_STRUCTINFO{
	char *name;
	struct VN_FIELDINFO *fi;  /* immediate field data info  */
	char nodetype;
	char fields;              /*  number of node specific fields  */
	short size;
	short flags;              /*  default node flags  */
	};


struct VN_NodeLink {            /*  Node Link, allows multiple links to same node  */
	struct VN_NodeLink *next;   /*  next sibling */
	struct VN_NodeLink *prev;   /*  previous sibling */
	struct VN_NodeLink *parent;
	struct VN_Nod *node;
	};


enum {                      /*  Node flags  */
	VNF_MULTINODE =  1,     /*  during parsing, denotes that additional sibling nodes may follow  */
	VNF_ISBINDABLE = 2,     /*  heirachy independent nodes need a secondary link directly to root  */
	VNF_FERTILE =    4,     /*  node has fields with child node capability  */
	VNF_FLDCHG =     8,     /*  at least one node field has changed since last rendering  */
//	VNF_TRAVERSE =   8,     /*  node should be traversed during rendering pass  */
	VNF_BOL0 =      16,     /*  storage for node boolean flags  */
	VNF_BOL1 =      32,
	VNF_BOL2 =      64
	};

struct VN_Nod {     /*  Common Node  */
	short type;
	short use;      /*  reference count, when 0 node should be disposed  */
	short flags;
	short field;    /*  during parse, used for current field or
					    unsupported node recursion count  */
	char *define;	/*  DEF name  */
					/*  model, when valid should contain a QD3D display group  */
	struct OpaqueTQ3Object *model;  /*  parent class type of TQ3GroupObject  */
	};


enum {                       /*  Root Node field id  */
	VNT_ROOT_CHILDREN = 1,
	VNT_ROOT_VIEWS
	};

struct VN_Root {             /*  Root Node  */
	struct VN_Nod node;
	VDT_NODELINKPTR children;
	VDT_NODELINKPTR views;
	};


/*  VRML 2.0 Node structure definitions  */

#define VN_Viewpoint_defaultz 10.0  /*  VRML 97 is 10.0  */
#define VN_Viewpoint_default_fov 60.0  /*  VRML 97 is 45.0  */

struct VN_Viewpoint {
	struct VN_Nod node;
	VDT_NODELINKPTR nextview;
	VDT_NODELINKPTR prevview;
	VDT_NODELINKPTR root;
	VDT_FLOAT fieldOfView;
	VDT_ROTATION orientation;
	VDT_VEC3F position;
	char *description;
	};

enum {  /* field parse tags  */
	VNT_TRANSFORM_CHILDREN = 1
	};

struct VN_Transform0 {
	struct VN_Nod node;
	VDT_NODELINKPTR children;
	VDT_ROTATION rotation;
	VDT_VEC3F translation;
	VDT_FLOAT bboxCenter[3];
	VDT_FLOAT bboxSize[3];
	struct OpaqueTQ3Object *xform_m;  /*  parent class type of TQ3GroupObject  */
//	TQ3TransformObject xform_m;  /*  Matrix Transform  */
	};

enum {  /* field parse tags  */
	VNT_GROUP_CHILDREN = 1
	};

struct VN_Group {
	struct VN_Nod node;
	VDT_NODELINKPTR children;
	VDT_FLOAT bboxCenter[3];
	VDT_FLOAT bboxSize[3];
	};

enum {  /* field parse tags  */
	VNT_SHAPE_APPEARANCE = 1,
	VNT_SHAPE_GEOMETRY
	};

struct VN_Shape {
	struct VN_Nod node;
	VDT_NODELINKPTR appearance;
	VDT_NODELINKPTR geometry;
	};

struct VN_Appearance {
	struct VN_Nod node;
	VDT_NODELINKPTR material;
	};

struct VN_Material {
	struct VN_Nod node;
	VDT_FLOAT ambientIntensity;
	VDT_FLOAT diffuseColor[3];
	VDT_FLOAT emissiveColor[3];
	VDT_FLOAT shininess;
	VDT_FLOAT specularColor[3];
	VDT_FLOAT transparency;
	};

struct VN_Box {
	struct VN_Nod node;
	float size[3];
	};

enum {  /*  Cylinder flag bits  */
	VNF_CYLINDER_TOP = VNF_BOL0,
	VNF_CYLINDER_BOTTOM = VNF_BOL1,
	VNF_CYLINDER_SIDE = VNF_BOL2
	};

struct VN_Cylinder {
	struct VN_Nod node;
	VDT_FLOAT height;
	VDT_FLOAT radius;
	};

enum {  /* field parse tags  */
	VNT_INDEXEDFACESET_COORD = 1
	};

struct VN_IndexedFaceSet {
	struct VN_Nod node;
	VDT_NODELINKPTR coord;
	VDT_INT32 *coordIndex;
	long ncoordIndexs;  /*  intergate this as first element of coordIndex?  */
	};

struct VN_Coordinate {
	struct VN_Nod node;
	struct VDT_VEC3F *point;
	long npoints;
	};


/*  function prototypes  */
vrml(struct VN_NodeLink **nodelink, short method, short value);
